/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4DxEntry;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4DxNode
implements StructConverter {
    private int fake_inode;
    private short fake_rec_len;
    private byte name_len;
    private byte file_type;
    private short limit;
    private short count;
    private int block;
    private Ext4DxEntry[] entries;

    public Ext4DxNode(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4DxNode(BinaryReader reader) throws IOException {
        this.fake_inode = reader.readNextInt();
        this.fake_rec_len = reader.readNextShort();
        this.name_len = reader.readNextByte();
        this.file_type = reader.readNextByte();
        this.limit = reader.readNextShort();
        this.count = reader.readNextShort();
        this.block = reader.readNextInt();
        this.entries = new Ext4DxEntry[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.entries[i] = new Ext4DxEntry(reader);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return null;
    }
}

