/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.Msg;

class RemoveEquateCmd
implements Command<Program> {
    private String[] equateNames;
    private String msg;

    RemoveEquateCmd(String ... equateNames) {
        this.equateNames = equateNames;
    }

    public String getName() {
        return "Remove Equate" + (this.equateNames.length > 1 ? "s" : "");
    }

    public boolean applyTo(Program program) {
        EquateTable etable = program.getEquateTable();
        boolean success = true;
        for (String name : this.equateNames) {
            if (etable.removeEquate(name)) continue;
            Msg.error((Object)this, (Object)("Failed to remove equate: " + name));
            success = false;
        }
        if (!success) {
            this.msg = "Failed to remove one or more equates";
        }
        return success;
    }

    public String getStatusMsg() {
        return this.msg;
    }
}

