/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.AddressSpaceSettingsDefinition;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.ComponentOffsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.OffsetMaskSettingsDefinition;
import ghidra.program.model.data.OffsetShiftSettingsDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.DataConverter;
import ghidra.util.StringUtilities;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public class PointerDataType
extends BuiltIn
implements Pointer {
    public static final PointerDataType dataType = new PointerDataType();
    public static final int MAX_POINTER_SIZE_BYTES = 8;
    public static final String POINTER_NAME = "pointer";
    public static final String POINTER_LABEL_PREFIX = "PTR";
    public static final String POINTER_LABEL_PREFIX_U = "PTR_";
    public static final String POINTER_LOOP_LABEL = "PTR_LOOP";
    public static final String NOT_A_POINTER = "NaP";
    private static TypeDefSettingsDefinition[] POINTER_TYPEDEF_SETTINGS_DEFS = new TypeDefSettingsDefinition[]{PointerTypeSettingsDefinition.DEF, AddressSpaceSettingsDefinition.DEF, OffsetMaskSettingsDefinition.DEF, OffsetShiftSettingsDefinition.DEF, ComponentOffsetSettingsDefinition.DEF};
    protected DataType referencedDataType;
    protected int length;
    private boolean deleted = false;
    private String displayName;
    private ThreadLocal<Boolean> isEquivalentActive = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public PointerDataType() {
        this(null, -1, null);
    }

    public PointerDataType(DataTypeManager dtm) {
        this(null, -1, dtm);
    }

    public PointerDataType(DataType referencedDataType) {
        this(referencedDataType, -1, null);
    }

    public PointerDataType(DataType referencedDataType, int length) {
        this(referencedDataType, length, null);
    }

    public PointerDataType(DataType referencedDataType, DataTypeManager dtm) {
        this(referencedDataType, -1, dtm);
    }

    public PointerDataType(DataType referencedDataType, int length, DataTypeManager dtm) {
        super(referencedDataType != null ? referencedDataType.getCategoryPath() : null, PointerDataType.constructUniqueName(referencedDataType, length), dtm);
        if (referencedDataType instanceof BitFieldDataType) {
            throw new IllegalArgumentException("Pointer reference data-type may not be a bitfield: " + referencedDataType.getName());
        }
        this.length = length <= 0 ? -1 : length;
        this.referencedDataType = referencedDataType;
        if (referencedDataType != null) {
            referencedDataType.addParent(this);
        }
    }

    @Override
    public final Pointer clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PointerDataType(this.referencedDataType, this.length, dtm);
    }

    @Override
    public DataType getDataType() {
        return this.referencedDataType;
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.length <= 0;
    }

    @Override
    public int getLength() {
        return this.length <= 0 ? this.getDataOrganization().getPointerSize() : this.length;
    }

    @Override
    public int getAlignedLength() {
        return this.getLength();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return POINTER_LABEL_PREFIX;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return PointerDataType.getLabelString(buf, settings, this.getLength(), options);
    }

    public static String getLabelString(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        Program program = buf.getMemory().getProgram();
        if (program == null) {
            return POINTER_LABEL_PREFIX;
        }
        Address fromAddr = buf.getAddress();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference ref = refMgr.getPrimaryReferenceFrom(fromAddr, 0);
        if (ref == null) {
            return POINTER_LABEL_PREFIX;
        }
        Symbol symbol = program.getSymbolTable().getSymbol(ref);
        if (symbol == null) {
            return POINTER_LABEL_PREFIX;
        }
        if (symbol.getSource() != SourceType.DEFAULT) {
            return POINTER_LABEL_PREFIX_U + symbol.getName();
        }
        PointerReferenceClassification pointerClassification = PointerDataType.getPointerClassification(program, ref);
        if (pointerClassification == PointerReferenceClassification.DEEP) {
            return "PTR_PTR";
        }
        if (pointerClassification == PointerReferenceClassification.LOOP) {
            return POINTER_LOOP_LABEL;
        }
        String symName = symbol.getName();
        symName = SymbolUtilities.getCleanSymbolName(symName, ref.getToAddress());
        if (!(symName = symName.replace("::", "_")).startsWith(POINTER_LABEL_PREFIX_U)) {
            return POINTER_LABEL_PREFIX_U + symName;
        }
        return POINTER_LABEL_PREFIX_U + symName;
    }

    private static PointerReferenceClassification getPointerClassification(Program program, Reference ref) {
        Address toAddr;
        Address fromAddr = ref.getFromAddress();
        HashSet<Address> refAddrs = new HashSet<Address>();
        refAddrs.add(fromAddr);
        if (fromAddr.equals(ref.getToAddress())) {
            return PointerReferenceClassification.LOOP;
        }
        int depth = 1;
        while (ref != null && ref.isMemoryReference() && refAddrs.add(toAddr = ref.getToAddress())) {
            if (++depth > 2) {
                return PointerReferenceClassification.DEEP;
            }
            Data data = PointerDataType.getDataAt(program, toAddr);
            if (data == null) break;
            ref = data.getPrimaryReference(0);
        }
        return PointerReferenceClassification.NORMAL;
    }

    private static Data getDataAt(Program program, Address addr) {
        int offset;
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(addr);
        if (data != null && (offset = (int)addr.subtract(data.getAddress())) != 0) {
            data = data.getPrimitiveAt(offset);
        }
        return data;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            DataType dt = this.getDataType();
            if (dt == null) {
                this.displayName = POINTER_NAME;
                if (this.length > 0) {
                    this.displayName = this.displayName + Integer.toString(8 * this.length);
                }
            } else {
                this.displayName = dt.getDisplayName() + " *";
            }
        }
        return this.displayName;
    }

    private static String constructUniqueName(DataType referencedDataType, int ptrLength) {
        if (referencedDataType == null) {
            Object s = POINTER_NAME;
            if (ptrLength > 0) {
                s = (String)s + Integer.toString(8 * ptrLength);
            }
            return s;
        }
        String s = referencedDataType.getName() + " *";
        if (ptrLength > 0) {
            s = s + Integer.toString(8 * ptrLength);
        }
        return s;
    }

    @Override
    public String getDescription() {
        StringBuilder sbuf = new StringBuilder();
        if (this.length > 0) {
            sbuf.append(Integer.toString(8 * this.length));
            sbuf.append("-bit ");
        }
        sbuf.append(POINTER_NAME);
        DataType dt = this.getDataType();
        if (dt != null) {
            sbuf.append(" to ");
            if (dt instanceof Pointer) {
                sbuf.append(this.getDataType().getDescription());
            } else {
                sbuf.append(this.getDataType().getDisplayName());
            }
        }
        return sbuf.toString();
    }

    @Override
    public String getMnemonic(Settings settings) {
        if (this.referencedDataType == null || this.referencedDataType == DataType.DEFAULT) {
            return "addr";
        }
        return this.referencedDataType.getMnemonic(settings) + " *";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int len) {
        return PointerDataType.getAddressValue(buf, this.getLength(), settings);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return POINTER_TYPEDEF_SETTINGS_DEFS;
    }

    public static Address getAddressValue(MemBuffer buf, int size, Settings settings) {
        return PointerDataType.getAddressValue(buf, size, settings, msg -> {});
    }

    public static Address getAddressValue(MemBuffer buf, int size, Settings settings, Consumer<String> errorHandler) {
        int shift;
        Long offset;
        String spaceName = AddressSpaceSettingsDefinition.DEF.getValue(settings);
        AddressSpace targetSpace = null;
        Memory mem = buf.getMemory();
        boolean signedOffset = false;
        PointerType pointerType = PointerTypeSettingsDefinition.DEF.getType(settings);
        if (pointerType == PointerType.RELATIVE) {
            signedOffset = true;
        }
        if ((offset = PointerDataType.getStoredOffset(buf, size, signedOffset, errorHandler)) == null) {
            return null;
        }
        long addrOffset = offset;
        long mask = OffsetMaskSettingsDefinition.DEF.getValue(settings);
        if (mask == 0L) {
            errorHandler.accept("Invalid pointer mask: 0");
            return null;
        }
        if (mask != -1L) {
            addrOffset &= mask;
        }
        if ((shift = (int)OffsetShiftSettingsDefinition.DEF.getValue(settings)) < 0) {
            addrOffset = signedOffset ? (addrOffset >>= -shift) : (addrOffset >>>= -shift);
        } else if (shift > 0) {
            addrOffset <<= shift;
        }
        try {
            if (pointerType != PointerType.DEFAULT && spaceName != null) {
                errorHandler.accept("Address Space and Pointer Type settings conflict");
                return null;
            }
            if (pointerType == PointerType.IMAGE_BASE_RELATIVE) {
                if (addrOffset == 0L) {
                    return null;
                }
                if (mem == null) {
                    errorHandler.accept("Memory not specified");
                }
                Address imageBase = mem.getProgram().getImageBase();
                targetSpace = imageBase.getAddressSpace();
                return imageBase.addWrap(addrOffset * (long)targetSpace.getAddressableUnitSize());
            }
            if (pointerType == PointerType.RELATIVE) {
                if (addrOffset == 0L) {
                    return null;
                }
                Address base = buf.getAddress();
                targetSpace = base.getAddressSpace();
                return base.addWrap(addrOffset * (long)targetSpace.getAddressableUnitSize());
            }
            if (pointerType == PointerType.FILE_OFFSET) {
                if (mem == null) {
                    errorHandler.accept("Memory not specified");
                } else if (mem.getAllFileBytes().size() == 0) {
                    errorHandler.accept("No File bytes used");
                } else {
                    List<Address> addressList = mem.locateAddressesForFileOffset(addrOffset);
                    if (addressList.size() == 1) {
                        return addressList.get(0);
                    }
                    if (addressList.size() > 1) {
                        errorHandler.accept("Non-unique File offset mapping: 0x" + Long.toHexString(addrOffset));
                    } else {
                        errorHandler.accept("File offset mapping not found: 0x" + Long.toHexString(addrOffset));
                    }
                }
                return null;
            }
            if (pointerType != PointerType.DEFAULT) {
                errorHandler.accept("Unsupported pointer type: " + pointerType.toString());
                return null;
            }
            if (spaceName != null) {
                if (mem == null) {
                    errorHandler.accept("Memory not specified");
                    return null;
                }
                Program program = mem.getProgram();
                targetSpace = program.getAddressFactory().getAddressSpace(spaceName);
                if (targetSpace == null) {
                    errorHandler.accept("Address space not defined: " + spaceName + ":" + PointerDataType.formatOffset(addrOffset));
                    return null;
                }
            }
            if (targetSpace == null) {
                targetSpace = buf.getAddress().getAddressSpace();
            }
            if (targetSpace instanceof SegmentedAddressSpace) {
                if (size != 2 && size != 4) {
                    errorHandler.accept("Unsupported segmented address size: " + size);
                    return null;
                }
                if (mask != -1L || shift != 0) {
                    errorHandler.accept("Unsupported mask/shift setting for segmented address");
                    return null;
                }
                return PointerDataType.getSegmentedAddressValue(buf, size, addrOffset);
            }
            return targetSpace.getAddress(addrOffset, true);
        }
        catch (AddressOutOfBoundsException | IllegalArgumentException e) {
            errorHandler.accept(e.toString());
            return null;
        }
    }

    private static String formatOffset(long offset) {
        String offsetStr = Long.toHexString(offset);
        int len = offsetStr.length();
        len = len - len % 4 + 4;
        return StringUtilities.pad((String)offsetStr, (char)'0', (int)len);
    }

    private static Long getStoredOffset(MemBuffer buf, int size, boolean signed, Consumer<String> errorHandler) {
        byte[] bytes = new byte[size];
        int cnt = buf.getBytes(bytes, 0);
        if (cnt != size) {
            if (cnt != 0 && errorHandler != null) {
                errorHandler.accept("Insufficient data");
            }
            return null;
        }
        DataConverter converter = DataConverter.getInstance((boolean)buf.isBigEndian());
        if (signed) {
            return converter.getSignedValue(bytes, size);
        }
        return converter.getValue(bytes, size);
    }

    public static Address getAddressValue(MemBuffer buf, int size, AddressSpace targetSpace) {
        if (size <= 0 || size > 8) {
            return null;
        }
        Long offset = PointerDataType.getStoredOffset(buf, size, false, null);
        if (offset == null) {
            return null;
        }
        if (targetSpace instanceof SegmentedAddressSpace) {
            try {
                return PointerDataType.getSegmentedAddressValue(buf, size, offset);
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }
        try {
            return targetSpace.getAddress(offset, true);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            return null;
        }
    }

    private static Address getSegmentedAddressValue(MemBuffer buf, int dataLen, long storedOffset) {
        int offset;
        SegmentedAddress a = (SegmentedAddress)buf.getAddress();
        int segment = a.getSegment();
        switch (dataLen) {
            case 2: {
                offset = (int)(storedOffset & 0xFFFFL);
                break;
            }
            case 4: {
                segment = (int)(storedOffset >> 16 & 0xFFFFL);
                offset = (int)(storedOffset & 0xFFFFL);
                break;
            }
            default: {
                return null;
            }
        }
        SegmentedAddressSpace space = (SegmentedAddressSpace)a.getAddressSpace();
        SegmentedAddress addr = space.getAddress(segment, offset);
        return PointerDataType.normalize(addr, buf.getMemory());
    }

    private static SegmentedAddress normalize(SegmentedAddress addr, Memory memory) {
        if (memory == null) {
            return addr;
        }
        MemoryBlock block = memory.getBlock(addr);
        if (block == null) {
            return addr;
        }
        SegmentedAddress start = (SegmentedAddress)block.getStart();
        return addr.normalize(start.getSegment());
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int len) {
        Address addr = (Address)this.getValue(buf, settings, len);
        if (addr == null) {
            return NOT_A_POINTER;
        }
        return addr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (this == dt) {
            return true;
        }
        if (!(dt instanceof Pointer)) {
            return false;
        }
        Pointer p = (Pointer)dt;
        DataType otherDataType = p.getDataType();
        if (this.hasLanguageDependantLength() != p.hasLanguageDependantLength()) {
            return false;
        }
        if (!this.hasLanguageDependantLength() && this.getLength() != p.getLength()) {
            return false;
        }
        if (this.referencedDataType == null) {
            return otherDataType == null;
        }
        if (otherDataType == null) {
            return false;
        }
        if (DataTypeUtilities.isSameDataType(this.referencedDataType, otherDataType)) {
            return true;
        }
        if (!DataTypeUtilities.equalsIgnoreConflict(this.referencedDataType.getPathName(), otherDataType.getPathName())) {
            return false;
        }
        if (this.isEquivalentActive.get().booleanValue()) {
            return true;
        }
        this.isEquivalentActive.set(true);
        try {
            boolean bl = this.getDataType().isEquivalent(otherDataType);
            return bl;
        }
        finally {
            this.isEquivalentActive.set(false);
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.referencedDataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (this.referencedDataType == oldDt) {
            this.referencedDataType.removeParent(this);
            this.referencedDataType = newDt;
            this.referencedDataType.addParent(this);
            this.displayName = null;
            String oldName = this.name;
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        if (this.referencedDataType == dt) {
            this.displayName = null;
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
            this.notifyNameChanged(oldName);
        }
    }

    @Override
    public CategoryPath getCategoryPath() {
        DataType dt = this.getDataType();
        if (dt == null) {
            return CategoryPath.ROOT;
        }
        return dt.getCategoryPath();
    }

    @Override
    public boolean dependsOn(DataType dt) {
        if (this.referencedDataType == null) {
            return false;
        }
        return this.referencedDataType == dt || this.referencedDataType.dependsOn(dt);
    }

    public static Pointer getPointer(DataType dt, DataTypeManager dtm) {
        return new PointerDataType(dt, dtm);
    }

    public static Pointer getPointer(DataType dt, int pointerSize) {
        if (pointerSize < 1 || pointerSize > 8) {
            return new PointerDataType(dt);
        }
        return new PointerDataType(dt, pointerSize);
    }

    @Override
    public Pointer newPointer(DataType dt) {
        if (dt != null) {
            dt = dt.clone(this.getDataTypeManager());
        }
        return new PointerDataType(dt, this.length, this.getDataTypeManager());
    }

    @Override
    public String getName() {
        if (this.referencedDataType != null) {
            this.name = PointerDataType.constructUniqueName(this.referencedDataType, this.length);
        }
        return super.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private static enum PointerReferenceClassification {
        NORMAL,
        LOOP,
        DEEP;

    }
}

