/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslatorAdapter;

public class ProgramArchitectureTranslator
extends LanguageTranslatorAdapter {
    private CompilerSpec oldCompilerSpec;
    private CompilerSpec newCompilerSpec;

    public ProgramArchitectureTranslator(Language oldLanguage, CompilerSpecID oldCompilerSpecId, Language newLanguage, CompilerSpecID newCompilerSpecId) throws CompilerSpecNotFoundException, IncompatibleLanguageException {
        super(oldLanguage, newLanguage);
        if (!oldLanguage.getProcessor().equals(newLanguage.getProcessor())) {
            throw new IncompatibleLanguageException("Architecture processors differ: " + String.valueOf(oldLanguage.getProcessor()) + " vs " + String.valueOf(newLanguage.getProcessor()));
        }
        this.oldCompilerSpec = oldLanguage.getCompilerSpecByID(oldCompilerSpecId);
        this.newCompilerSpec = newLanguage.getCompilerSpecByID(newCompilerSpecId);
        this.validateDefaultSpaceMap();
    }

    public ProgramArchitectureTranslator(LanguageID oldLanguageId, int oldLanguageVersion, CompilerSpecID oldCompilerSpecId, Language newLanguage, CompilerSpecID newCompilerSpecId) throws LanguageNotFoundException, CompilerSpecNotFoundException, IncompatibleLanguageException {
        this(ProgramArchitectureTranslator.getLanguage(oldLanguageId, oldLanguageVersion), oldCompilerSpecId, newLanguage, newCompilerSpecId);
    }

    private static Language getLanguage(LanguageID languageId, int languageVersion) throws LanguageNotFoundException {
        Language language = DefaultLanguageService.getLanguageService().getLanguage(languageId);
        if (languageVersion > 0 && language.getVersion() != languageVersion) {
            throw new LanguageNotFoundException("Language not found for '" + String.valueOf(languageId) + "' version " + languageVersion + ".x");
        }
        return language;
    }

    public CompilerSpec getOldCompilerSpec() {
        return this.oldCompilerSpec;
    }

    public CompilerSpec getNewCompilerSpec() {
        return this.newCompilerSpec;
    }
}

