/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorer;
import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.graph.Hypergraph;

public abstract class AbstractIterativeScorerWithPriors<V, E, S>
extends AbstractIterativeScorer<V, E, S>
implements VertexScorer<V, S> {
    protected Function<? super V, ? extends S> vertex_priors;
    protected double alpha;

    public AbstractIterativeScorerWithPriors(Hypergraph<V, E> g, Function<? super E, ? extends Number> edge_weights, Function<? super V, ? extends S> vertex_priors, double alpha) {
        super(g, edge_weights);
        this.vertex_priors = vertex_priors;
        this.alpha = alpha;
        this.initialize();
    }

    public AbstractIterativeScorerWithPriors(Hypergraph<V, E> g, Function<V, ? extends S> vertex_priors, double alpha) {
        super(g);
        this.vertex_priors = vertex_priors;
        this.alpha = alpha;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (Object v : this.graph.getVertices()) {
            this.setOutputValue(v, this.getVertexPrior(v));
        }
    }

    protected S getVertexPrior(V v) {
        return (S)this.vertex_priors.apply(v);
    }

    public Function<? super V, ? extends S> getVertexPriors() {
        return this.vertex_priors;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

