/*
 * Decompiled with CFR 0.152.
 */
package docking.menu.keys;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

abstract class MenuKeyHandler {
    MenuKeyHandler() {
    }

    abstract void process(MenuSelectionManager var1, MenuElement[] var2);

    protected int getLeafPopupIndex(MenuElement[] path) {
        if (path != null) {
            for (int i = path.length - 1; i >= 0; --i) {
                MenuElement menuElement = path[i];
                if (!(menuElement instanceof JPopupMenu)) continue;
                return i;
            }
        }
        return -1;
    }

    protected JPopupMenu getLeafPopupMenu(MenuElement[] path) {
        int index = this.getLeafPopupIndex(path);
        if (index >= 0) {
            return (JPopupMenu)path[index];
        }
        return null;
    }

    protected int findActiveMenuItemIndex(MenuSelectionManager manager, MenuElement[] path) {
        int popupIndexdex = this.getLeafPopupIndex(path);
        if (popupIndexdex == -1) {
            return -1;
        }
        if (popupIndexdex == path.length - 1) {
            return -1;
        }
        MenuElement activeItem = path[path.length - 1];
        JPopupMenu popup = (JPopupMenu)path[popupIndexdex];
        int count = 0;
        int n = popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (!this.isValidItem(c)) continue;
            if (activeItem == c) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    protected int findActiveMenuItemRawIndex(MenuSelectionManager manager, MenuElement[] path) {
        int popupIndexdex = this.getLeafPopupIndex(path);
        if (popupIndexdex == -1) {
            return -1;
        }
        if (popupIndexdex == path.length - 1) {
            return -1;
        }
        MenuElement activeItem = path[path.length - 1];
        JPopupMenu popup = (JPopupMenu)path[popupIndexdex];
        int count = 0;
        int n = popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (activeItem == c) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    protected int findNextSeparatorIndex(JPopupMenu popup, int startIndex) {
        int n = popup.getComponentCount();
        for (int i = startIndex; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (!(c instanceof JSeparator)) continue;
            return i;
        }
        return -1;
    }

    protected int findPreviousSeparatorIndex(JPopupMenu popup, int startIndex) {
        for (int i = startIndex; i >= 0; --i) {
            Component c = popup.getComponent(i);
            if (!(c instanceof JSeparator)) continue;
            return i;
        }
        return -1;
    }

    protected int findNextValidIndex(JPopupMenu popup, int startIndex) {
        int n = popup.getComponentCount();
        for (int i = startIndex; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (!this.isValidItem(c)) continue;
            return i;
        }
        return -1;
    }

    protected int findPreviousValidIndex(JPopupMenu popup, int startIndex) {
        for (int i = startIndex; i >= 0; --i) {
            Component c = popup.getComponent(i);
            if (!this.isValidItem(c)) continue;
            return i;
        }
        return -1;
    }

    protected int moveForward(MenuSelectionManager manager, MenuElement[] path, int offset) {
        JPopupMenu popup = this.getLeafPopupMenu(path);
        if (popup == null) {
            return -1;
        }
        int itemCount = this.getItemCount(popup);
        if (itemCount == 0) {
            return -1;
        }
        int updatedOffset = offset >= itemCount ? offset % itemCount : offset;
        int progress = 0;
        int n = popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (!this.isValidItem(c)) continue;
            if (progress == updatedOffset) {
                return i;
            }
            ++progress;
        }
        return -1;
    }

    protected void setNewMenuItemIndex(MenuSelectionManager manager, MenuElement[] path, int index) {
        if (index < 0) {
            return;
        }
        int popupIndex = this.getLeafPopupIndex(path);
        JPopupMenu popup = (JPopupMenu)path[popupIndex];
        JMenuItem newItem = (JMenuItem)popup.getComponent(index);
        int length = path.length - 1 == popupIndex ? path.length + 1 : path.length;
        MenuElement[] newPath = new MenuElement[length];
        System.arraycopy(path, 0, newPath, 0, popupIndex + 1);
        newPath[popupIndex + 1] = newItem;
        manager.setSelectedPath(newPath);
    }

    protected MenuElement getNextValidItem(JPopupMenu popup, int start) {
        int n = popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int updated = i + start;
            int index = updated < n ? updated : Math.abs(i - (n - start));
            Component c = popup.getComponent(index);
            if (!this.isValidItem(c)) continue;
            return (MenuElement)((Object)c);
        }
        return null;
    }

    protected MenuElement getPreviousValidItem(JPopupMenu popup, int offset) {
        int n = popup.getComponentCount();
        for (int i = n - 1; i >= 0; --i) {
            int updated = n - (i + 1);
            int index = updated > offset ? updated : offset - updated;
            Component c = popup.getComponent(index);
            if (!this.isValidItem(c)) continue;
            return (MenuElement)((Object)c);
        }
        return null;
    }

    protected int getItemCount(JPopupMenu popup) {
        int count = 0;
        int n = popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = popup.getComponent(i);
            if (!this.isValidItem(c)) continue;
            ++count;
        }
        return count;
    }

    protected boolean isValidItem(Component c) {
        return c instanceof JMenuItem && c.isEnabled();
    }
}

