/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.configuration.problems;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.gradle.internal.cc.impl.problems.JsonWriter;
import org.gradle.internal.configuration.problems.DecoratedFailure;
import org.gradle.internal.configuration.problems.DecoratedReportProblem;
import org.gradle.internal.configuration.problems.DecoratedReportProblemKt;
import org.gradle.internal.configuration.problems.ProblemDescriptionKt;
import org.gradle.internal.configuration.problems.PropertyKind;
import org.gradle.internal.configuration.problems.PropertyProblemKt;
import org.gradle.internal.configuration.problems.PropertyTrace;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/configuration/problems/DecoratedReportProblemJsonSource;", "Lorg/gradle/internal/cc/impl/problems/JsonSource;", "problem", "Lorg/gradle/internal/configuration/problems/DecoratedReportProblem;", "<init>", "(Lorg/gradle/internal/configuration/problems/DecoratedReportProblem;)V", "writeToJson", "", "jsonWriter", "Lorg/gradle/internal/cc/impl/problems/JsonWriter;", "writePropertyTrace", "trace", "Lorg/gradle/internal/configuration/problems/PropertyTrace;", "kind", "Lorg/gradle/internal/configuration/problems/PropertyTrace$Property;", "configuration-problems-base"})
public final class DecoratedReportProblemJsonSource
implements JsonSource {
    @NotNull
    private final DecoratedReportProblem problem;

    public DecoratedReportProblemJsonSource(@NotNull DecoratedReportProblem problem2) {
        Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
        this.problem = problem2;
    }

    @Override
    public void writeToJson(@NotNull JsonWriter jsonWriter) {
        Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
        JsonWriter $this$writeToJson_u24lambda_u240 = jsonWriter;
        boolean bl = false;
        $this$writeToJson_u24lambda_u240.jsonListItem((Function0<Unit>)((Function0)() -> DecoratedReportProblemJsonSource.writeToJson$lambda$0$0($this$writeToJson_u24lambda_u240, this)));
    }

    private final void writePropertyTrace(JsonWriter $this$writePropertyTrace, PropertyTrace trace) {
        PropertyTrace propertyTrace = trace;
        if (propertyTrace instanceof PropertyTrace.Property) {
            switch (WhenMappings.$EnumSwitchMapping$0[((PropertyTrace.Property)trace).getKind().ordinal()]) {
                case 1: {
                    this.kind($this$writePropertyTrace, (PropertyTrace.Property)trace);
                    String string = ProblemDescriptionKt.firstTypeFrom(((PropertyTrace.Property)trace).getTrace()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    $this$writePropertyTrace.property("declaringType", string);
                    break;
                }
                case 2: {
                    this.kind($this$writePropertyTrace, (PropertyTrace.Property)trace);
                    $this$writePropertyTrace.property("from", ProblemDescriptionKt.projectPathFrom(((PropertyTrace.Property)trace).getTrace()));
                    break;
                }
                default: {
                    this.kind($this$writePropertyTrace, (PropertyTrace.Property)trace);
                    $this$writePropertyTrace.property("task", ProblemDescriptionKt.taskPathFrom(((PropertyTrace.Property)trace).getTrace()));
                    break;
                }
            }
        } else if (propertyTrace instanceof PropertyTrace.SystemProperty) {
            $this$writePropertyTrace.property("kind", "SystemProperty");
            $this$writePropertyTrace.property("name", ((PropertyTrace.SystemProperty)trace).getName());
        } else if (propertyTrace instanceof PropertyTrace.Task) {
            $this$writePropertyTrace.property("kind", "Task");
            $this$writePropertyTrace.property("path", ((PropertyTrace.Task)trace).getPath());
            String string = ((PropertyTrace.Task)trace).getType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $this$writePropertyTrace.property("type", string);
        } else if (propertyTrace instanceof PropertyTrace.Bean) {
            $this$writePropertyTrace.property("kind", "Bean");
            String string = ((PropertyTrace.Bean)trace).getType().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $this$writePropertyTrace.property("type", string);
        } else if (propertyTrace instanceof PropertyTrace.Project) {
            $this$writePropertyTrace.property("kind", "Project");
            $this$writePropertyTrace.property("path", ((PropertyTrace.Project)trace).getPath());
        } else if (propertyTrace instanceof PropertyTrace.BuildLogic) {
            $this$writePropertyTrace.property("kind", "BuildLogic");
            String string = ((PropertyTrace.BuildLogic)trace).getSource().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            $this$writePropertyTrace.property("location", string);
        } else if (propertyTrace instanceof PropertyTrace.BuildLogicClass) {
            $this$writePropertyTrace.property("kind", "BuildLogicClass");
            $this$writePropertyTrace.property("type", ((PropertyTrace.BuildLogicClass)trace).getName());
        } else if (Intrinsics.areEqual((Object)propertyTrace, (Object)PropertyTrace.Gradle.INSTANCE)) {
            $this$writePropertyTrace.property("kind", "Gradle");
        } else if (Intrinsics.areEqual((Object)propertyTrace, (Object)PropertyTrace.Unknown.INSTANCE)) {
            $this$writePropertyTrace.property("kind", "Unknown");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void kind(JsonWriter $this$kind, PropertyTrace.Property trace) {
        $this$kind.property("kind", trace.getKind().name());
        $this$kind.property("name", trace.getName());
    }

    private static final Unit writeToJson$lambda$0$0(JsonWriter $this_with, DecoratedReportProblemJsonSource this$0) {
        $this_with.jsonObject((Function0<Unit>)((Function0)() -> DecoratedReportProblemJsonSource.writeToJson$lambda$0$0$0($this_with, this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit writeToJson$lambda$0$0$0(JsonWriter $this_with, DecoratedReportProblemJsonSource this$0) {
        block1: {
            Object it;
            $this_with.property("trace", (Function0<Unit>)((Function0)() -> DecoratedReportProblemJsonSource.writeToJson$lambda$0$0$0$0($this_with, this$0)));
            $this_with.property(this$0.problem.getKind(), (Function0<Unit>)((Function0)() -> DecoratedReportProblemJsonSource.writeToJson$lambda$0$0$0$1($this_with, this$0)));
            String string = this$0.problem.getDocLink();
            if (string != null) {
                it = string;
                boolean bl = false;
                $this_with.property("documentationLink", (String)it);
            }
            DecoratedFailure decoratedFailure = this$0.problem.getFailure();
            if (decoratedFailure == null) break block1;
            it = decoratedFailure;
            boolean bl = false;
            DecoratedReportProblemKt.writeError($this_with, (DecoratedFailure)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeToJson$lambda$0$0$0$0(JsonWriter $this_with, DecoratedReportProblemJsonSource this$0) {
        $this_with.jsonObjectList(SequencesKt.asIterable(this$0.problem.getTrace().getSequence()), arg_0 -> DecoratedReportProblemJsonSource.writeToJson$lambda$0$0$0$0$0(this$0, $this_with, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit writeToJson$lambda$0$0$0$0$0(DecoratedReportProblemJsonSource this$0, JsonWriter $this_with, PropertyTrace trace) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this$0.writePropertyTrace($this_with, trace);
        return Unit.INSTANCE;
    }

    private static final Unit writeToJson$lambda$0$0$0$1(JsonWriter $this_with, DecoratedReportProblemJsonSource this$0) {
        PropertyProblemKt.writeStructuredMessage($this_with, this$0.problem.getMessage());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyKind.values().length];
            try {
                nArray[PropertyKind.Field.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.PropertyUsage.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

