/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public final class ConvertSimpleGetterToPropertyIntention
extends GrPsiUpdateIntention {
    private static final String[] MODIFIERS_TO_CHECK = new String[]{"static", "private", "protected"};

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        GrMethod method;
        GrOpenBlock block;
        if (element == null) {
            ConvertSimpleGetterToPropertyIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConvertSimpleGetterToPropertyIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ConvertSimpleGetterToPropertyIntention.$$$reportNull$$$0(2);
        }
        if ((block = (method = (GrMethod)element.getParent()).getBlock()) == null) {
            return;
        }
        GrStatement statement = block.getStatements()[0];
        GrExpression value = statement instanceof GrReturnStatement ? ((GrReturnStatement)statement).getReturnValue() : (GrExpression)statement;
        String fieldName = GroovyPropertyUtils.getPropertyNameByGetter(method);
        if (fieldName == null) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        ArrayList<String> modifiers = new ArrayList<String>();
        for (String modifier : MODIFIERS_TO_CHECK) {
            if (!method.hasModifierProperty(modifier)) continue;
            modifiers.add(modifier);
        }
        modifiers.add("final");
        GrTypeElement returnTypeElement = method.getReturnTypeElementGroovy();
        PsiType returnType = returnTypeElement == null ? null : returnTypeElement.getType();
        GrVariableDeclaration declaration = GroovyPsiElementFactory.getInstance(context.project()).createFieldDeclaration(ArrayUtilRt.toStringArray(modifiers), fieldName, value, returnType);
        PsiElement replaced = method.replace(declaration);
        JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences(replaced);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                GrMethod method;
                PsiElement parent;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = element.getParent()) instanceof GrMethod) || (method = (GrMethod)parent).getNameIdentifierGroovy() != element) {
                    return false;
                }
                GrOpenBlock block = method.getBlock();
                if (block == null) {
                    return false;
                }
                GrStatement[] statements = block.getStatements();
                if (statements.length != 1) {
                    return false;
                }
                if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
                    return false;
                }
                if (GroovyPropertyUtils.findFieldForAccessor(method, true) != null) {
                    return false;
                }
                GrStatement statement = statements[0];
                return statement instanceof GrReturnStatement && ((GrReturnStatement)statement).getReturnValue() != null || statement instanceof GrExpression && !PsiTypes.voidType().equals((Object)((GrExpression)statement).getType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertSimpleGetterToPropertyIntention$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertSimpleGetterToPropertyIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

