/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.common.Clock;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Util;

public class ConnectionCreationBroker
implements Diagnosable {
    static final String CLASS_NAME = ConnectionCreationBroker.class.getName();
    private static final Long MIN_INTERVAL = 1000L;
    public static final Long MAX_INTERVAL = 3000L;
    private volatile long recentAttemptTimestamp = 0L;
    private volatile long retryInterval = 0L;
    private final Lock lock = new ReentrantLock();
    private final BlockingSemaphore blockingSemaphore = new BlockingSemaphore();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    public ConnectionCreationBroker(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    @Debug(level=Debug.Level.FINEST)
    void markDbAsOperable() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsOperable", "entering args ()", null, null, new Object[0]);
            this.lock.lock();
            try {
                this.recentAttemptTimestamp = 0L;
                this.retryInterval = 0L;
                this.trace(Level.FINEST, CLASS_NAME, "markDbAsOperable", "marked db as operable: broker={0}", null, null, this.toString());
                this.blockingSemaphore.unblock();
            }
            finally {
                this.lock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsOperable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsOperable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void markDbAsInoperable() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsInoperable", "entering args ()", null, null, new Object[0]);
            this.lock.lock();
            try {
                this.blockingSemaphore.block();
                if (0L == this.recentAttemptTimestamp) {
                    this.recentAttemptTimestamp = Clock.clock();
                    this.retryInterval = MIN_INTERVAL;
                    this.trace(Level.FINEST, CLASS_NAME, "markDbAsInoperable", "marked db as inoperable: broker={0}", null, null, this.toString());
                }
            }
            finally {
                this.lock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsInoperable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "markDbAsInoperable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    long appointNextAttempt() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "appointNextAttempt", "entering args ()", null, null, new Object[0]);
            this.lock.lock();
            if (0L == this.recentAttemptTimestamp) {
                long l = 0L;
                long l2 = l;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "appointNextAttempt", "returning {0}", null, null, l2);
                return l2;
            }
            long now = Clock.clock();
            long timeToWait = Math.max(0L, this.recentAttemptTimestamp + this.retryInterval - now);
            if (0L == timeToWait) {
                this.recentAttemptTimestamp = now;
                long retryDelay = Util.getConnectionCreationRetryDelay();
                this.trace(Level.FINEST, CLASS_NAME, "appointNextAttempt", "retryDelay={0}", null, null, retryDelay);
                this.retryInterval = Math.min(retryDelay, 2L * this.retryInterval);
            }
            this.trace(Level.FINEST, CLASS_NAME, "appointNextAttempt", "timeToWait={0}, broker={1}", null, null, timeToWait, this.toString());
            long l = timeToWait;
            long l3 = l;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "appointNextAttempt", "returning {0}", null, null, l3);
            return l3;
            finally {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "appointNextAttempt", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    void waitOnBroker(long l) {
        try {
            void msecsToWait;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "waitOnBroker", "entering args ({0})", null, null, l);
            this.blockingSemaphore.waitOnSemaphore((long)msecsToWait);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "waitOnBroker", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ConnectionCreationBroker", "waitOnBroker", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public String toString() {
        return "recentAttemptTimestamp=" + this.recentAttemptTimestamp + ", retryInterval=" + this.retryInterval;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    private class BlockingSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 4343640747509L;
        private boolean blocked;

        BlockingSemaphore() {
            super(Integer.MAX_VALUE);
            this.blocked = false;
        }

        private void block() {
            if (!this.blocked) {
                super.reducePermits(Integer.MAX_VALUE);
                this.blocked = true;
            }
        }

        private void unblock() {
            if (this.blocked) {
                super.release(Integer.MAX_VALUE);
                this.blocked = false;
            }
        }

        private void waitOnSemaphore(long msecsToWait) {
            try {
                if (super.tryAcquire(msecsToWait, TimeUnit.MILLISECONDS)) {
                    super.release();
                }
            }
            catch (InterruptedException e) {
                ConnectionCreationBroker.this.trace(Level.WARNING, CLASS_NAME, "waitOnSemaphore", "", null, e, new Object[0]);
            }
        }
    }
}

