/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.tasks.resourcetracker;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="2.15.0")
public class TaskResourceInfo
implements Writeable,
ToXContentObject {
    private final String action;
    private final long taskId;
    private final long parentTaskId;
    private final String nodeId;
    private final TaskResourceUsage taskResourceUsage;
    private static final ParseField ACTION = new ParseField("action", new String[0]);
    private static final ParseField TASK_ID = new ParseField("taskId", new String[0]);
    private static final ParseField PARENT_TASK_ID = new ParseField("parentTaskId", new String[0]);
    private static final ParseField NODE_ID = new ParseField("nodeId", new String[0]);
    private static final ParseField TASK_RESOURCE_USAGE = new ParseField("taskResourceUsage", new String[0]);
    public static final ConstructingObjectParser<TaskResourceInfo, Void> PARSER = new ConstructingObjectParser("task_resource_info", a -> new Builder().setAction((String)a[0]).setTaskId((Long)a[1]).setParentTaskId((Long)a[2]).setNodeId((String)a[3]).setTaskResourceUsage((TaskResourceUsage)a[4]).build());

    public TaskResourceInfo(String action, long taskId, long parentTaskId, String nodeId, TaskResourceUsage taskResourceUsage) {
        this.action = action;
        this.taskId = taskId;
        this.parentTaskId = parentTaskId;
        this.nodeId = nodeId;
        this.taskResourceUsage = taskResourceUsage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTION.getPreferredName(), this.action);
        builder.field(TASK_ID.getPreferredName(), this.taskId);
        builder.field(PARENT_TASK_ID.getPreferredName(), this.parentTaskId);
        builder.field(NODE_ID.getPreferredName(), this.nodeId);
        builder.startObject(TASK_RESOURCE_USAGE.getPreferredName());
        this.taskResourceUsage.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static TaskResourceInfo readFromStream(StreamInput in) throws IOException {
        return new Builder().setAction(in.readString()).setTaskId(in.readLong()).setParentTaskId(in.readLong()).setNodeId(in.readString()).setTaskResourceUsage(TaskResourceUsage.readFromStream(in)).build();
    }

    public TaskResourceUsage getTaskResourceUsage() {
        return this.taskResourceUsage;
    }

    public long getParentTaskId() {
        return this.parentTaskId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getAction() {
        return this.action;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.action);
        out.writeLong(this.taskId);
        out.writeLong(this.parentTaskId);
        out.writeString(this.nodeId);
        this.taskResourceUsage.writeTo(out);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResourceInfo.class) {
            return false;
        }
        TaskResourceInfo other = (TaskResourceInfo)obj;
        return this.action.equals(other.action) && this.taskId == other.taskId && this.parentTaskId == other.parentTaskId && Objects.equals(this.nodeId, other.nodeId) && this.taskResourceUsage.equals(other.taskResourceUsage);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.taskId, this.parentTaskId, this.nodeId, this.taskResourceUsage);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTION);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TASK_ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PARENT_TASK_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TaskResourceUsage.PARSER, TASK_RESOURCE_USAGE);
    }

    public static class Builder {
        private TaskResourceUsage taskResourceUsage;
        private String action;
        private long taskId;
        private long parentTaskId;
        private String nodeId;

        public Builder setTaskResourceUsage(TaskResourceUsage taskResourceUsage) {
            this.taskResourceUsage = taskResourceUsage;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setTaskId(long taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder setParentTaskId(long parentTaskId) {
            this.parentTaskId = parentTaskId;
            return this;
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public TaskResourceInfo build() {
            return new TaskResourceInfo(this.action, this.taskId, this.parentTaskId, this.nodeId, this.taskResourceUsage);
        }
    }
}

