/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.preproc.OptionKey;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.warning.Warning;

public class EaterOption
extends Eater {
    public EaterOption(StringLocated s) {
        super(s);
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        TValue value;
        this.skipSpaces();
        this.checkAndEatChar("!option");
        this.skipSpaces();
        String key = this.eatAndGetVarname();
        this.skipSpaces();
        try {
            value = this.eatExpression(context, memory);
        }
        catch (EaterException e) {
            value = null;
        }
        this.skipSpaces();
        OptionKey optionKey = OptionKey.lazyFrom(key);
        if (optionKey == null) {
            context.getPreprocessingArtifact().addWarning(new Warning("No such !option " + key));
        } else if (value == null && optionKey.getDefaultValue() == null) {
            context.getPreprocessingArtifact().addWarning(new Warning("No default value for " + key));
        } else if (value == null) {
            context.getPreprocessingArtifact().getOption().define(optionKey, optionKey.getDefaultValue());
        } else {
            context.getPreprocessingArtifact().getOption().define(optionKey, value.toString());
        }
    }
}

