let _ = Mltop.add_known_module "rocq-runtime.plugins.number_string_notation"

# 13 "plugins/syntax/g_number_string.mlg"
 

open Notation
open Number_string
open Pp
open Stdarg
open Procq.Prim

let pr_number_after = function
  | Nop -> mt ()
  | Warning n -> str "warning after " ++ NumTok.UnsignedNat.print n
  | Abstract n -> str "abstract after " ++ NumTok.UnsignedNat.print n

let pr_number_string_mapping (b, n, n') =
  if b then
    str "[" ++ Libnames.pr_qualid n ++ str "]" ++ spc () ++ str "=>" ++ spc ()
    ++ Libnames.pr_qualid n'
  else
    Libnames.pr_qualid n ++ spc () ++ str "=>" ++ spc ()
    ++ Libnames.pr_qualid n'

let pr_number_string_via (n, l) =
  str "via " ++ Libnames.pr_qualid n ++ str " mapping ["
  ++ prlist_with_sep pr_comma pr_number_string_mapping l ++ str "]"

let pr_number_modifier = function
  | After a -> pr_number_after a
  | Via nl -> pr_number_string_via nl

let pr_number_options l =
  str "(" ++ prlist_with_sep pr_comma pr_number_modifier l ++ str ")"

let pr_string_option l =
  str "(" ++ pr_number_string_via l ++ str ")"


# 41 "plugins/syntax/g_number_string.ml"

let (wit_number_string_mapping, number_string_mapping) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~name:"number_string_mapping" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next
           (Procq.Rule.next (Procq.Rule.stop)
            ((Procq.Symbol.token (Procq.terminal "["))))
           ((Procq.Symbol.nterm reference)))
          ((Procq.Symbol.token (Procq.terminal "]"))))
         ((Procq.Symbol.token (Procq.terminal "=>"))))
        ((Procq.Symbol.nterm reference)))
       (fun n' _ _ n _ loc -> 
# 53 "plugins/syntax/g_number_string.mlg"
                                                   true, n, n' 
# 62 "plugins/syntax/g_number_string.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop) ((Procq.Symbol.nterm reference)))
        ((Procq.Symbol.token (Procq.terminal "=>"))))
       ((Procq.Symbol.nterm reference)))
      (fun n' _ n loc -> 
# 52 "plugins/syntax/g_number_string.mlg"
                                           false, n, n' 
# 73 "plugins/syntax/g_number_string.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 51 "plugins/syntax/g_number_string.mlg"
               pr_number_string_mapping 
# 78 "plugins/syntax/g_number_string.ml"
;
    }
let _ = (wit_number_string_mapping, number_string_mapping)

let (wit_number_string_via, number_string_via) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~name:"number_string_via" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next
          (Procq.Rule.next
           (Procq.Rule.next
            (Procq.Rule.next (Procq.Rule.stop)
             ((Procq.Symbol.token (Procq.terminal "via"))))
            ((Procq.Symbol.nterm reference)))
           ((Procq.Symbol.token (Procq.terminal "mapping"))))
          ((Procq.Symbol.token (Procq.terminal "["))))
         ((Procq.Symbol.list1sep ((Procq.Symbol.nterm number_string_mapping)) ((Procq.Symbol.rules 
         [Procq.Rules.make (Procq.Rule.next_norec (Procq.Rule.stop)
                            ((Procq.Symbol.token (Procq.terminal ","))))
                           (fun _ loc -> ())])) false)))
        ((Procq.Symbol.token (Procq.terminal "]"))))
       (fun _ l _ _ n _ loc -> 
# 58 "plugins/syntax/g_number_string.mlg"
                                                                                          n, l 
# 107 "plugins/syntax/g_number_string.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 57 "plugins/syntax/g_number_string.mlg"
               pr_number_string_via 
# 112 "plugins/syntax/g_number_string.ml"
;
    }
let _ = (wit_number_string_via, number_string_via)

let (wit_number_modifier, number_modifier) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~name:"number_modifier" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next (Procq.Rule.stop)
        ((Procq.Symbol.nterm number_string_via)))
       (fun v loc -> 
# 65 "plugins/syntax/g_number_string.mlg"
                                Via v 
# 128 "plugins/syntax/g_number_string.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "abstract"))))
        ((Procq.Symbol.token (Procq.terminal "after"))))
       ((Procq.Symbol.nterm bignat)))
      (fun n _ _ loc -> 
# 64 "plugins/syntax/g_number_string.mlg"
                                        After (Abstract (NumTok.UnsignedNat.of_string n)) 
# 140 "plugins/syntax/g_number_string.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "warning"))))
        ((Procq.Symbol.token (Procq.terminal "after"))))
       ((Procq.Symbol.nterm bignat)))
      (fun waft _ _ loc -> 
# 63 "plugins/syntax/g_number_string.mlg"
                                          After (Warning (NumTok.UnsignedNat.of_string waft)) 
# 152 "plugins/syntax/g_number_string.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 62 "plugins/syntax/g_number_string.mlg"
               pr_number_modifier 
# 157 "plugins/syntax/g_number_string.ml"
;
    }
let _ = (wit_number_modifier, number_modifier)

let (wit_number_options, number_options) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~name:"number_options" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "("))))
         ((Procq.Symbol.list1sep ((Procq.Symbol.nterm number_modifier)) ((Procq.Symbol.rules 
         [Procq.Rules.make (Procq.Rule.next_norec (Procq.Rule.stop)
                            ((Procq.Symbol.token (Procq.terminal ","))))
                           (fun _ loc -> ())])) false)))
        ((Procq.Symbol.token (Procq.terminal ")"))))
       (fun _ l _ loc -> 
# 70 "plugins/syntax/g_number_string.mlg"
                                                       l 
# 180 "plugins/syntax/g_number_string.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 69 "plugins/syntax/g_number_string.mlg"
               pr_number_options 
# 185 "plugins/syntax/g_number_string.ml"
;
    }
let _ = (wit_number_options, number_options)

let (wit_string_option, string_option) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~name:"string_option" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next
         (Procq.Rule.next (Procq.Rule.stop)
          ((Procq.Symbol.token (Procq.terminal "("))))
         ((Procq.Symbol.nterm number_string_via)))
        ((Procq.Symbol.token (Procq.terminal ")"))))
       (fun _ v _ loc -> 
# 75 "plugins/syntax/g_number_string.mlg"
                                        v 
# 205 "plugins/syntax/g_number_string.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 74 "plugins/syntax/g_number_string.mlg"
               pr_string_option 
# 210 "plugins/syntax/g_number_string.ml"
;
    }
let _ = (wit_string_option, string_option)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~command:"NumberNotation" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Number",
           Vernacextend.TyTerminal
           ("Notation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_number_options)),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_preident),
             Vernacextend.TyNil)))))))),
          (let coqpp_body ty f g nl sc locality =
            Vernactypes.vtdefault (fun () -> 
# 82 "plugins/syntax/g_number_string.mlg"
      vernac_number_notation (Locality.make_module_locality locality) ty f g (Option.default [] nl) sc 
# 234 "plugins/syntax/g_number_string.ml"
) in
            fun ty f g nl sc ?loc ~atts () ->
            coqpp_body ty f g nl sc (Attributes.parse 
# 79 "plugins/syntax/g_number_string.mlg"
                   Attributes.locality
# 240 "plugins/syntax/g_number_string.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.number_string_notation") ~command:"StringNotation" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("String",
           Vernacextend.TyTerminal
           ("Notation",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference),
            Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_string_option)),
            Vernacextend.TyTerminal
            (":",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_preident),
             Vernacextend.TyNil)))))))),
          (let coqpp_body ty f g o sc locality =
            Vernactypes.vtdefault (fun () -> 
# 88 "plugins/syntax/g_number_string.mlg"
      vernac_string_notation (Locality.make_module_locality locality) ty f g o sc 
# 263 "plugins/syntax/g_number_string.ml"
) in
            fun ty f g o sc ?loc ~atts () ->
            coqpp_body ty f g o sc (Attributes.parse 
# 86 "plugins/syntax/g_number_string.mlg"
                   Attributes.locality
# 269 "plugins/syntax/g_number_string.ml"
 atts)),
          None))]

