/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.SharedMemorySync;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;
import java.lang.invoke.VarHandle;

@ExportLibrary(value=InteropLibrary.class)
public final class JSWebAssemblyMemoryWaitCallback
implements TruffleObject {
    private static final int INT32_BYTES_PER_ELEMENT = 4;
    private static final int BIGINT64_BYTES_PER_ELEMENT = 8;
    private final JSRealm realm;
    private final JSContext context;

    public JSWebAssemblyMemoryWaitCallback(JSRealm realm, JSContext context) {
        this.realm = realm;
        this.context = context;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] arguments) {
        assert (arguments.length == 5);
        JSWebAssemblyMemoryObject memoryObject = JSWebAssemblyMemory.create(this.context, this.realm, arguments[0], true);
        long address = (Long)arguments[1];
        long expected = (Long)arguments[2];
        long timeout = (Long)arguments[3];
        double convertedTimeout = timeout >= 0L ? (double)timeout / 1000000.0 : Double.POSITIVE_INFINITY;
        boolean is64 = (Boolean)arguments[4];
        JSArrayBufferObject buffer = memoryObject.getBufferObject(this.context, this.realm);
        TruffleString result = this.atomicsWait(buffer, (int)address, expected, convertedTimeout, is64);
        if (Strings.equals(result, Strings.OK)) {
            return 0;
        }
        if (Strings.equals(result, Strings.NOT_EQUAL)) {
            return 1;
        }
        assert (Strings.equals(result, Strings.TIMED_OUT));
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TruffleString atomicsWait(JSArrayBufferObject buffer, int address, long expected, double timeout, boolean is64) {
        JSAgent agent = this.realm.getAgent();
        if (!agent.canBlock()) {
            throw Errors.createRuntimeError("wait instruction used by agent which cannot block", this.realm);
        }
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(buffer);
        JSAgentWaiterList.JSAgentWaiterListEntry wl = !is64 ? waiterList.getListForIndex(address * 4) : waiterList.getListForIndex(address * 8);
        wl.enterCriticalSection();
        try {
            if (!is64) {
                int val = JSWebAssemblyMemoryWaitCallback.doVolatileGetFromBuffer(buffer, address);
                if ((long)val != expected) {
                    TruffleString truffleString = Strings.NOT_EQUAL;
                    return truffleString;
                }
            } else {
                BigInt val = JSWebAssemblyMemoryWaitCallback.doVolatileGetBigIntFromBuffer(buffer, address);
                if (val.longValue() != expected) {
                    TruffleString truffleString = Strings.NOT_EQUAL;
                    return truffleString;
                }
            }
            int id = agent.getSignifier();
            JSAgentWaiterList.WaiterRecord waiterRecord = JSAgentWaiterList.WaiterRecord.create(id, null, timeout, Strings.OK, wl, agent);
            SharedMemorySync.addWaiter(agent, wl, waiterRecord, false);
            boolean awoken = SharedMemorySync.suspendAgent(agent, wl, waiterRecord);
            if (awoken) {
                assert (!wl.contains(waiterRecord));
                TruffleString truffleString = Strings.OK;
                return truffleString;
            }
            SharedMemorySync.removeWaiter(wl, waiterRecord);
            TruffleString truffleString = Strings.TIMED_OUT;
            return truffleString;
        }
        finally {
            wl.leaveCriticalSection();
        }
    }

    private static int doVolatileGetFromBuffer(JSArrayBufferObject buffer, int intArrayOffset) {
        TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)TypedArrayFactory.Int32Array.createArrayType((byte)1, false, true);
        int result = typedArray.getBufferElementIntImpl(buffer, intArrayOffset, true, InteropLibrary.getUncached());
        VarHandle.acquireFence();
        return result;
    }

    private static BigInt doVolatileGetBigIntFromBuffer(JSArrayBufferObject buffer, int bigIntArrayOffset) {
        TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)TypedArrayFactory.BigInt64Array.createArrayType((byte)1, false, true);
        BigInt result = BigInt.valueOf(typedArray.getBufferElementLongImpl(buffer, bigIntArrayOffset, true, InteropLibrary.getUncached()));
        VarHandle.acquireFence();
        return result;
    }
}

