/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.native_memory.NativeBuffer;
import com.oracle.graal.python.runtime.sequence.storage.NativePrimitiveSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;

public class NativeIntSequenceStorage
extends NativePrimitiveSequenceStorage {
    public NativeIntSequenceStorage(NativeBuffer valueBuffer, int length) {
        super(valueBuffer, length, 4L);
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Int;
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    public int getIntItemNormalized(int idx) {
        long indexInBytes = (long)idx * 4L;
        return unsafe.getInt(this.getValueBufferAddr() + indexInBytes);
    }

    public void setIntItemNormalized(int idx, int value) {
        long indexInBytes = (long)idx * 4L;
        unsafe.putInt(this.getValueBufferAddr() + indexInBytes, value);
    }
}

