/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class ByteArgument
extends TypedArgument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.ByteSpb);
    private static final long serialVersionUID = 3202369601515235550L;
    private final byte value;

    public ByteArgument(int type, ArgumentType argumentType, byte value) {
        super(type, argumentType);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + (Object)((Object)argumentType));
        }
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.writeValue(outputStream, this.value);
    }

    @Override
    public int getLength() {
        return 2 + this.argumentType.getLengthSize();
    }

    private void writeValue(OutputStream outputStream, byte value) throws IOException {
        this.argumentType.writeLength(1, outputStream);
        outputStream.write(value);
    }

    @Override
    public int getValueAsInt() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType(), this.value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArgument)) {
            return false;
        }
        ByteArgument otherByteArgument = (ByteArgument)other;
        return this.getType() == otherByteArgument.getType() && this.value == otherByteArgument.value;
    }

    public int hashCode() {
        int result = 943 + this.getType();
        result = 41 * result + this.value;
        return result;
    }
}

