/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.vector;

import java.util.List;
import org.apache.solr.common.SolrException;

public abstract class DenseVectorParser {
    protected BuilderPhase builderPhase;
    protected int dimension;
    protected Object inputValue;

    public float[] getFloatVector() {
        throw new UnsupportedOperationException("Float vector parsing is not supported");
    }

    public byte[] getByteVector() {
        throw new UnsupportedOperationException("Byte vector parsing is not supported");
    }

    protected void parseVector() {
        switch (this.builderPhase) {
            case INDEX: {
                this.parseIndexVector();
                break;
            }
            case QUERY: {
                this.parseQueryVector();
            }
        }
    }

    protected void parseIndexVector() {
        if (!(this.inputValue instanceof List)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector format. " + this.errorMessage());
        }
        List inputVector = (List)this.inputValue;
        this.checkVectorDimension(inputVector.size());
        if (inputVector.get(0) instanceof CharSequence) {
            for (int i = 0; i < this.dimension; ++i) {
                try {
                    this.addStringElement(inputVector.get(i).toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector element: '" + String.valueOf(inputVector.get(i)) + "'. " + this.errorMessage());
                }
            }
        } else if (inputVector.get(0) instanceof Number) {
            for (int i = 0; i < this.dimension; ++i) {
                this.addNumberElement((Number)inputVector.get(i));
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector format. " + this.errorMessage());
        }
    }

    protected void parseQueryVector() {
        String value = this.inputValue.toString();
        if (!value.startsWith("[") || !value.endsWith("]")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector format. " + this.errorMessage());
        }
        String[] elements = value.substring(1, value.length() - 1).split(",");
        this.checkVectorDimension(elements.length);
        for (int i = 0; i < this.dimension; ++i) {
            try {
                this.addStringElement(elements[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector element: '" + elements[i] + "'. " + this.errorMessage());
            }
        }
    }

    protected void checkVectorDimension(int inputVectorDimension) {
        if (inputVectorDimension != this.dimension) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector dimension. The vector value has size " + inputVectorDimension + " while it is expected a vector with size " + this.dimension);
        }
    }

    protected abstract void addNumberElement(Number var1);

    protected abstract void addStringElement(String var1);

    protected abstract String errorMessage();

    public static enum BuilderPhase {
        INDEX,
        QUERY;

    }
}

