/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.update.processor;

import java.lang.invoke.MethodHandles;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.crossdc.common.KafkaMirroringSink;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.apache.solr.crossdc.common.MirroringException;
import org.apache.solr.crossdc.update.processor.RequestMirroringHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRequestMirroringHandler
implements RequestMirroringHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final KafkaMirroringSink sink;

    public KafkaRequestMirroringHandler(KafkaMirroringSink sink) {
        log.debug("create KafkaRequestMirroringHandler");
        this.sink = sink;
    }

    @Override
    public void mirror(UpdateRequest request) throws MirroringException {
        if (log.isTraceEnabled()) {
            log.trace("submit update to sink docs={}, deletes={}, params={}", new Object[]{request.getDocuments(), request.getDeleteById(), request.getParams()});
        }
        MirroredSolrRequest mirroredRequest = new MirroredSolrRequest(MirroredSolrRequest.Type.UPDATE, 1, request, System.nanoTime());
        try {
            this.sink.submit(mirroredRequest);
        }
        catch (MirroringException exception) {
            if (log.isInfoEnabled()) {
                log.info("Sending message to dead letter queue");
            }
            this.sink.submitToDlq(mirroredRequest);
            throw new MirroringException(exception);
        }
    }
}

