﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/appfabric/model/AppBundle.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppFabric {
namespace Model {
class CreateAppBundleResult {
 public:
  AWS_APPFABRIC_API CreateAppBundleResult() = default;
  AWS_APPFABRIC_API CreateAppBundleResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPFABRIC_API CreateAppBundleResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Contains information about an app bundle.</p>
   */
  inline const AppBundle& GetAppBundle() const { return m_appBundle; }
  template <typename AppBundleT = AppBundle>
  void SetAppBundle(AppBundleT&& value) {
    m_appBundleHasBeenSet = true;
    m_appBundle = std::forward<AppBundleT>(value);
  }
  template <typename AppBundleT = AppBundle>
  CreateAppBundleResult& WithAppBundle(AppBundleT&& value) {
    SetAppBundle(std::forward<AppBundleT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateAppBundleResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AppBundle m_appBundle;
  bool m_appBundleHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
