﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/BedrockRequest.h>
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Bedrock {
namespace Model {

/**
 */
class DeleteAutomatedReasoningPolicyBuildWorkflowRequest : public BedrockRequest {
 public:
  AWS_BEDROCK_API DeleteAutomatedReasoningPolicyBuildWorkflowRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAutomatedReasoningPolicyBuildWorkflow"; }

  AWS_BEDROCK_API Aws::String SerializePayload() const override;

  AWS_BEDROCK_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Automated Reasoning policy whose build
   * workflow you want to delete.</p>
   */
  inline const Aws::String& GetPolicyArn() const { return m_policyArn; }
  inline bool PolicyArnHasBeenSet() const { return m_policyArnHasBeenSet; }
  template <typename PolicyArnT = Aws::String>
  void SetPolicyArn(PolicyArnT&& value) {
    m_policyArnHasBeenSet = true;
    m_policyArn = std::forward<PolicyArnT>(value);
  }
  template <typename PolicyArnT = Aws::String>
  DeleteAutomatedReasoningPolicyBuildWorkflowRequest& WithPolicyArn(PolicyArnT&& value) {
    SetPolicyArn(std::forward<PolicyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the build workflow to delete.</p>
   */
  inline const Aws::String& GetBuildWorkflowId() const { return m_buildWorkflowId; }
  inline bool BuildWorkflowIdHasBeenSet() const { return m_buildWorkflowIdHasBeenSet; }
  template <typename BuildWorkflowIdT = Aws::String>
  void SetBuildWorkflowId(BuildWorkflowIdT&& value) {
    m_buildWorkflowIdHasBeenSet = true;
    m_buildWorkflowId = std::forward<BuildWorkflowIdT>(value);
  }
  template <typename BuildWorkflowIdT = Aws::String>
  DeleteAutomatedReasoningPolicyBuildWorkflowRequest& WithBuildWorkflowId(BuildWorkflowIdT&& value) {
    SetBuildWorkflowId(std::forward<BuildWorkflowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the build workflow was last updated. This is used for
   * optimistic concurrency control to prevent accidental deletion of workflows that
   * have been modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedAt() const { return m_lastUpdatedAt; }
  inline bool LastUpdatedAtHasBeenSet() const { return m_lastUpdatedAtHasBeenSet; }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  void SetLastUpdatedAt(LastUpdatedAtT&& value) {
    m_lastUpdatedAtHasBeenSet = true;
    m_lastUpdatedAt = std::forward<LastUpdatedAtT>(value);
  }
  template <typename LastUpdatedAtT = Aws::Utils::DateTime>
  DeleteAutomatedReasoningPolicyBuildWorkflowRequest& WithLastUpdatedAt(LastUpdatedAtT&& value) {
    SetLastUpdatedAt(std::forward<LastUpdatedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyArn;
  bool m_policyArnHasBeenSet = false;

  Aws::String m_buildWorkflowId;
  bool m_buildWorkflowIdHasBeenSet = false;

  Aws::Utils::DateTime m_lastUpdatedAt{};
  bool m_lastUpdatedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
