﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-sync/CognitoSync_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CognitoSync {
namespace Model {

/**
 * Usage information for the identity.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/IdentityUsage">AWS
 * API Reference</a></p>
 */
class IdentityUsage {
 public:
  AWS_COGNITOSYNC_API IdentityUsage() = default;
  AWS_COGNITOSYNC_API IdentityUsage(Aws::Utils::Json::JsonView jsonValue);
  AWS_COGNITOSYNC_API IdentityUsage& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COGNITOSYNC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
   * created by Amazon Cognito. GUID generation is unique within a region.
   */
  inline const Aws::String& GetIdentityId() const { return m_identityId; }
  inline bool IdentityIdHasBeenSet() const { return m_identityIdHasBeenSet; }
  template <typename IdentityIdT = Aws::String>
  void SetIdentityId(IdentityIdT&& value) {
    m_identityIdHasBeenSet = true;
    m_identityId = std::forward<IdentityIdT>(value);
  }
  template <typename IdentityIdT = Aws::String>
  IdentityUsage& WithIdentityId(IdentityIdT&& value) {
    SetIdentityId(std::forward<IdentityIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
   * created by Amazon Cognito. GUID generation is unique within a region.
   */
  inline const Aws::String& GetIdentityPoolId() const { return m_identityPoolId; }
  inline bool IdentityPoolIdHasBeenSet() const { return m_identityPoolIdHasBeenSet; }
  template <typename IdentityPoolIdT = Aws::String>
  void SetIdentityPoolId(IdentityPoolIdT&& value) {
    m_identityPoolIdHasBeenSet = true;
    m_identityPoolId = std::forward<IdentityPoolIdT>(value);
  }
  template <typename IdentityPoolIdT = Aws::String>
  IdentityUsage& WithIdentityPoolId(IdentityPoolIdT&& value) {
    SetIdentityPoolId(std::forward<IdentityPoolIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Date on which the identity was last modified.
   */
  inline const Aws::Utils::DateTime& GetLastModifiedDate() const { return m_lastModifiedDate; }
  inline bool LastModifiedDateHasBeenSet() const { return m_lastModifiedDateHasBeenSet; }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  IdentityUsage& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Number of datasets for the identity.
   */
  inline int GetDatasetCount() const { return m_datasetCount; }
  inline bool DatasetCountHasBeenSet() const { return m_datasetCountHasBeenSet; }
  inline void SetDatasetCount(int value) {
    m_datasetCountHasBeenSet = true;
    m_datasetCount = value;
  }
  inline IdentityUsage& WithDatasetCount(int value) {
    SetDatasetCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * Total data storage for this identity.
   */
  inline long long GetDataStorage() const { return m_dataStorage; }
  inline bool DataStorageHasBeenSet() const { return m_dataStorageHasBeenSet; }
  inline void SetDataStorage(long long value) {
    m_dataStorageHasBeenSet = true;
    m_dataStorage = value;
  }
  inline IdentityUsage& WithDataStorage(long long value) {
    SetDataStorage(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_identityId;
  bool m_identityIdHasBeenSet = false;

  Aws::String m_identityPoolId;
  bool m_identityPoolIdHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedDate{};
  bool m_lastModifiedDateHasBeenSet = false;

  int m_datasetCount{0};
  bool m_datasetCountHasBeenSet = false;

  long long m_dataStorage{0};
  bool m_dataStorageHasBeenSet = false;
};

}  // namespace Model
}  // namespace CognitoSync
}  // namespace Aws
