﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class UpdatePhoneNumberResult {
 public:
  AWS_CONNECT_API UpdatePhoneNumberResult() = default;
  AWS_CONNECT_API UpdatePhoneNumberResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API UpdatePhoneNumberResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A unique identifier for the phone number.</p>
   */
  inline const Aws::String& GetPhoneNumberId() const { return m_phoneNumberId; }
  template <typename PhoneNumberIdT = Aws::String>
  void SetPhoneNumberId(PhoneNumberIdT&& value) {
    m_phoneNumberIdHasBeenSet = true;
    m_phoneNumberId = std::forward<PhoneNumberIdT>(value);
  }
  template <typename PhoneNumberIdT = Aws::String>
  UpdatePhoneNumberResult& WithPhoneNumberId(PhoneNumberIdT&& value) {
    SetPhoneNumberId(std::forward<PhoneNumberIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the phone number.</p>
   */
  inline const Aws::String& GetPhoneNumberArn() const { return m_phoneNumberArn; }
  template <typename PhoneNumberArnT = Aws::String>
  void SetPhoneNumberArn(PhoneNumberArnT&& value) {
    m_phoneNumberArnHasBeenSet = true;
    m_phoneNumberArn = std::forward<PhoneNumberArnT>(value);
  }
  template <typename PhoneNumberArnT = Aws::String>
  UpdatePhoneNumberResult& WithPhoneNumberArn(PhoneNumberArnT&& value) {
    SetPhoneNumberArn(std::forward<PhoneNumberArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdatePhoneNumberResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_phoneNumberId;
  bool m_phoneNumberIdHasBeenSet = false;

  Aws::String m_phoneNumberArn;
  bool m_phoneNumberArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
