﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/directconnect/DirectConnectRequest.h>
#include <aws/directconnect/DirectConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DirectConnect {
namespace Model {

/**
 */
class DeleteDirectConnectGatewayAssociationRequest : public DirectConnectRequest {
 public:
  AWS_DIRECTCONNECT_API DeleteDirectConnectGatewayAssociationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteDirectConnectGatewayAssociation"; }

  AWS_DIRECTCONNECT_API Aws::String SerializePayload() const override;

  AWS_DIRECTCONNECT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ID of the Direct Connect gateway association.</p>
   */
  inline const Aws::String& GetAssociationId() const { return m_associationId; }
  inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
  template <typename AssociationIdT = Aws::String>
  void SetAssociationId(AssociationIdT&& value) {
    m_associationIdHasBeenSet = true;
    m_associationId = std::forward<AssociationIdT>(value);
  }
  template <typename AssociationIdT = Aws::String>
  DeleteDirectConnectGatewayAssociationRequest& WithAssociationId(AssociationIdT&& value) {
    SetAssociationId(std::forward<AssociationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Direct Connect gateway.</p>
   */
  inline const Aws::String& GetDirectConnectGatewayId() const { return m_directConnectGatewayId; }
  inline bool DirectConnectGatewayIdHasBeenSet() const { return m_directConnectGatewayIdHasBeenSet; }
  template <typename DirectConnectGatewayIdT = Aws::String>
  void SetDirectConnectGatewayId(DirectConnectGatewayIdT&& value) {
    m_directConnectGatewayIdHasBeenSet = true;
    m_directConnectGatewayId = std::forward<DirectConnectGatewayIdT>(value);
  }
  template <typename DirectConnectGatewayIdT = Aws::String>
  DeleteDirectConnectGatewayAssociationRequest& WithDirectConnectGatewayId(DirectConnectGatewayIdT&& value) {
    SetDirectConnectGatewayId(std::forward<DirectConnectGatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the virtual private gateway.</p>
   */
  inline const Aws::String& GetVirtualGatewayId() const { return m_virtualGatewayId; }
  inline bool VirtualGatewayIdHasBeenSet() const { return m_virtualGatewayIdHasBeenSet; }
  template <typename VirtualGatewayIdT = Aws::String>
  void SetVirtualGatewayId(VirtualGatewayIdT&& value) {
    m_virtualGatewayIdHasBeenSet = true;
    m_virtualGatewayId = std::forward<VirtualGatewayIdT>(value);
  }
  template <typename VirtualGatewayIdT = Aws::String>
  DeleteDirectConnectGatewayAssociationRequest& WithVirtualGatewayId(VirtualGatewayIdT&& value) {
    SetVirtualGatewayId(std::forward<VirtualGatewayIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_associationId;
  bool m_associationIdHasBeenSet = false;

  Aws::String m_directConnectGatewayId;
  bool m_directConnectGatewayIdHasBeenSet = false;

  Aws::String m_virtualGatewayId;
  bool m_virtualGatewayIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectConnect
}  // namespace Aws
