﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/eks/EKSRequest.h>
#include <aws/eks/EKS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace EKS {
namespace Model {

/**
 */
class DeleteNodegroupRequest : public EKSRequest {
 public:
  AWS_EKS_API DeleteNodegroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteNodegroup"; }

  AWS_EKS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of your cluster.</p>
   */
  inline const Aws::String& GetClusterName() const { return m_clusterName; }
  inline bool ClusterNameHasBeenSet() const { return m_clusterNameHasBeenSet; }
  template <typename ClusterNameT = Aws::String>
  void SetClusterName(ClusterNameT&& value) {
    m_clusterNameHasBeenSet = true;
    m_clusterName = std::forward<ClusterNameT>(value);
  }
  template <typename ClusterNameT = Aws::String>
  DeleteNodegroupRequest& WithClusterName(ClusterNameT&& value) {
    SetClusterName(std::forward<ClusterNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the node group to delete.</p>
   */
  inline const Aws::String& GetNodegroupName() const { return m_nodegroupName; }
  inline bool NodegroupNameHasBeenSet() const { return m_nodegroupNameHasBeenSet; }
  template <typename NodegroupNameT = Aws::String>
  void SetNodegroupName(NodegroupNameT&& value) {
    m_nodegroupNameHasBeenSet = true;
    m_nodegroupName = std::forward<NodegroupNameT>(value);
  }
  template <typename NodegroupNameT = Aws::String>
  DeleteNodegroupRequest& WithNodegroupName(NodegroupNameT&& value) {
    SetNodegroupName(std::forward<NodegroupNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clusterName;
  bool m_clusterNameHasBeenSet = false;

  Aws::String m_nodegroupName;
  bool m_nodegroupNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace EKS
}  // namespace Aws
