﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/geo-routes/GeoRoutes_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GeoRoutes {
namespace Model {

/**
 * <p>Provides a summary of a pedestrian route step.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/RoutePedestrianOverviewSummary">AWS
 * API Reference</a></p>
 */
class RoutePedestrianOverviewSummary {
 public:
  AWS_GEOROUTES_API RoutePedestrianOverviewSummary() = default;
  AWS_GEOROUTES_API RoutePedestrianOverviewSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API RoutePedestrianOverviewSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Distance of the step.</p>
   */
  inline long long GetDistance() const { return m_distance; }
  inline bool DistanceHasBeenSet() const { return m_distanceHasBeenSet; }
  inline void SetDistance(long long value) {
    m_distanceHasBeenSet = true;
    m_distance = value;
  }
  inline RoutePedestrianOverviewSummary& WithDistance(long long value) {
    SetDistance(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Duration of the step.</p>
   */
  inline long long GetDuration() const { return m_duration; }
  inline bool DurationHasBeenSet() const { return m_durationHasBeenSet; }
  inline void SetDuration(long long value) {
    m_durationHasBeenSet = true;
    m_duration = value;
  }
  inline RoutePedestrianOverviewSummary& WithDuration(long long value) {
    SetDuration(value);
    return *this;
  }
  ///@}
 private:
  long long m_distance{0};
  bool m_distanceHasBeenSet = false;

  long long m_duration{0};
  bool m_durationHasBeenSet = false;
};

}  // namespace Model
}  // namespace GeoRoutes
}  // namespace Aws
