﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/Account.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the user involved in the attack
 * sequence.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/User">AWS API
 * Reference</a></p>
 */
class User {
 public:
  AWS_GUARDDUTY_API User() = default;
  AWS_GUARDDUTY_API User(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API User& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the user.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  User& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the user.</p>
   */
  inline const Aws::String& GetUid() const { return m_uid; }
  inline bool UidHasBeenSet() const { return m_uidHasBeenSet; }
  template <typename UidT = Aws::String>
  void SetUid(UidT&& value) {
    m_uidHasBeenSet = true;
    m_uid = std::forward<UidT>(value);
  }
  template <typename UidT = Aws::String>
  User& WithUid(UidT&& value) {
    SetUid(std::forward<UidT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the user.</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  User& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The credentials of the user ID.</p>
   */
  inline const Aws::String& GetCredentialUid() const { return m_credentialUid; }
  inline bool CredentialUidHasBeenSet() const { return m_credentialUidHasBeenSet; }
  template <typename CredentialUidT = Aws::String>
  void SetCredentialUid(CredentialUidT&& value) {
    m_credentialUidHasBeenSet = true;
    m_credentialUid = std::forward<CredentialUidT>(value);
  }
  template <typename CredentialUidT = Aws::String>
  User& WithCredentialUid(CredentialUidT&& value) {
    SetCredentialUid(std::forward<CredentialUidT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the Amazon Web Services account.</p>
   */
  inline const Account& GetAccount() const { return m_account; }
  inline bool AccountHasBeenSet() const { return m_accountHasBeenSet; }
  template <typename AccountT = Account>
  void SetAccount(AccountT&& value) {
    m_accountHasBeenSet = true;
    m_account = std::forward<AccountT>(value);
  }
  template <typename AccountT = Account>
  User& WithAccount(AccountT&& value) {
    SetAccount(std::forward<AccountT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_uid;
  bool m_uidHasBeenSet = false;

  Aws::String m_type;
  bool m_typeHasBeenSet = false;

  Aws::String m_credentialUid;
  bool m_credentialUidHasBeenSet = false;

  Account m_account;
  bool m_accountHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
