﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/inspector/Inspector_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Inspector {
namespace Model {
class ListAssessmentTemplatesResult {
 public:
  AWS_INSPECTOR_API ListAssessmentTemplatesResult() = default;
  AWS_INSPECTOR_API ListAssessmentTemplatesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_INSPECTOR_API ListAssessmentTemplatesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of ARNs that specifies the assessment templates returned by the
   * action.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAssessmentTemplateArns() const { return m_assessmentTemplateArns; }
  template <typename AssessmentTemplateArnsT = Aws::Vector<Aws::String>>
  void SetAssessmentTemplateArns(AssessmentTemplateArnsT&& value) {
    m_assessmentTemplateArnsHasBeenSet = true;
    m_assessmentTemplateArns = std::forward<AssessmentTemplateArnsT>(value);
  }
  template <typename AssessmentTemplateArnsT = Aws::Vector<Aws::String>>
  ListAssessmentTemplatesResult& WithAssessmentTemplateArns(AssessmentTemplateArnsT&& value) {
    SetAssessmentTemplateArns(std::forward<AssessmentTemplateArnsT>(value));
    return *this;
  }
  template <typename AssessmentTemplateArnsT = Aws::String>
  ListAssessmentTemplatesResult& AddAssessmentTemplateArns(AssessmentTemplateArnsT&& value) {
    m_assessmentTemplateArnsHasBeenSet = true;
    m_assessmentTemplateArns.emplace_back(std::forward<AssessmentTemplateArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> When a response is generated, if there is more data to be listed, this
   * parameter is present in the response and contains the value to use for the
   * <b>nextToken</b> parameter in a subsequent pagination request. If there is no
   * more data to be listed, this parameter is set to null.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAssessmentTemplatesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAssessmentTemplatesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_assessmentTemplateArns;
  bool m_assessmentTemplateArnsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector
}  // namespace Aws
