﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediapackage-vod/MediaPackageVod_EXPORTS.h>
#include <aws/mediapackage-vod/model/HlsEncryption.h>
#include <aws/mediapackage-vod/model/HlsManifest.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaPackageVod {
namespace Model {

/**
 * An HTTP Live Streaming (HLS) packaging configuration.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/HlsPackage">AWS
 * API Reference</a></p>
 */
class HlsPackage {
 public:
  AWS_MEDIAPACKAGEVOD_API HlsPackage() = default;
  AWS_MEDIAPACKAGEVOD_API HlsPackage(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API HlsPackage& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const HlsEncryption& GetEncryption() const { return m_encryption; }
  inline bool EncryptionHasBeenSet() const { return m_encryptionHasBeenSet; }
  template <typename EncryptionT = HlsEncryption>
  void SetEncryption(EncryptionT&& value) {
    m_encryptionHasBeenSet = true;
    m_encryption = std::forward<EncryptionT>(value);
  }
  template <typename EncryptionT = HlsEncryption>
  HlsPackage& WithEncryption(EncryptionT&& value) {
    SetEncryption(std::forward<EncryptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A list of HLS manifest configurations.
   */
  inline const Aws::Vector<HlsManifest>& GetHlsManifests() const { return m_hlsManifests; }
  inline bool HlsManifestsHasBeenSet() const { return m_hlsManifestsHasBeenSet; }
  template <typename HlsManifestsT = Aws::Vector<HlsManifest>>
  void SetHlsManifests(HlsManifestsT&& value) {
    m_hlsManifestsHasBeenSet = true;
    m_hlsManifests = std::forward<HlsManifestsT>(value);
  }
  template <typename HlsManifestsT = Aws::Vector<HlsManifest>>
  HlsPackage& WithHlsManifests(HlsManifestsT&& value) {
    SetHlsManifests(std::forward<HlsManifestsT>(value));
    return *this;
  }
  template <typename HlsManifestsT = HlsManifest>
  HlsPackage& AddHlsManifests(HlsManifestsT&& value) {
    m_hlsManifestsHasBeenSet = true;
    m_hlsManifests.emplace_back(std::forward<HlsManifestsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * When enabled, MediaPackage passes through digital video broadcasting (DVB)
   * subtitles into the output.
   */
  inline bool GetIncludeDvbSubtitles() const { return m_includeDvbSubtitles; }
  inline bool IncludeDvbSubtitlesHasBeenSet() const { return m_includeDvbSubtitlesHasBeenSet; }
  inline void SetIncludeDvbSubtitles(bool value) {
    m_includeDvbSubtitlesHasBeenSet = true;
    m_includeDvbSubtitles = value;
  }
  inline HlsPackage& WithIncludeDvbSubtitles(bool value) {
    SetIncludeDvbSubtitles(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * Duration (in seconds) of each fragment. Actual fragments will be
rounded to the
   * nearest multiple of the source fragment duration.

   */
  inline int GetSegmentDurationSeconds() const { return m_segmentDurationSeconds; }
  inline bool SegmentDurationSecondsHasBeenSet() const { return m_segmentDurationSecondsHasBeenSet; }
  inline void SetSegmentDurationSeconds(int value) {
    m_segmentDurationSecondsHasBeenSet = true;
    m_segmentDurationSeconds = value;
  }
  inline HlsPackage& WithSegmentDurationSeconds(int value) {
    SetSegmentDurationSeconds(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * When enabled, audio streams will be placed in rendition groups in the output.
   */
  inline bool GetUseAudioRenditionGroup() const { return m_useAudioRenditionGroup; }
  inline bool UseAudioRenditionGroupHasBeenSet() const { return m_useAudioRenditionGroupHasBeenSet; }
  inline void SetUseAudioRenditionGroup(bool value) {
    m_useAudioRenditionGroupHasBeenSet = true;
    m_useAudioRenditionGroup = value;
  }
  inline HlsPackage& WithUseAudioRenditionGroup(bool value) {
    SetUseAudioRenditionGroup(value);
    return *this;
  }
  ///@}
 private:
  HlsEncryption m_encryption;
  bool m_encryptionHasBeenSet = false;

  Aws::Vector<HlsManifest> m_hlsManifests;
  bool m_hlsManifestsHasBeenSet = false;

  bool m_includeDvbSubtitles{false};
  bool m_includeDvbSubtitlesHasBeenSet = false;

  int m_segmentDurationSeconds{0};
  bool m_segmentDurationSecondsHasBeenSet = false;

  bool m_useAudioRenditionGroup{false};
  bool m_useAudioRenditionGroupHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
