﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mgn/MgnRequest.h>
#include <aws/mgn/Mgn_EXPORTS.h>

#include <utility>

namespace Aws {
namespace mgn {
namespace Model {

/**
 */
class DisassociateSourceServersRequest : public MgnRequest {
 public:
  AWS_MGN_API DisassociateSourceServersRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisassociateSourceServers"; }

  AWS_MGN_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Account ID.</p>
   */
  inline const Aws::String& GetAccountID() const { return m_accountID; }
  inline bool AccountIDHasBeenSet() const { return m_accountIDHasBeenSet; }
  template <typename AccountIDT = Aws::String>
  void SetAccountID(AccountIDT&& value) {
    m_accountIDHasBeenSet = true;
    m_accountID = std::forward<AccountIDT>(value);
  }
  template <typename AccountIDT = Aws::String>
  DisassociateSourceServersRequest& WithAccountID(AccountIDT&& value) {
    SetAccountID(std::forward<AccountIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Application ID.</p>
   */
  inline const Aws::String& GetApplicationID() const { return m_applicationID; }
  inline bool ApplicationIDHasBeenSet() const { return m_applicationIDHasBeenSet; }
  template <typename ApplicationIDT = Aws::String>
  void SetApplicationID(ApplicationIDT&& value) {
    m_applicationIDHasBeenSet = true;
    m_applicationID = std::forward<ApplicationIDT>(value);
  }
  template <typename ApplicationIDT = Aws::String>
  DisassociateSourceServersRequest& WithApplicationID(ApplicationIDT&& value) {
    SetApplicationID(std::forward<ApplicationIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Source server IDs list.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSourceServerIDs() const { return m_sourceServerIDs; }
  inline bool SourceServerIDsHasBeenSet() const { return m_sourceServerIDsHasBeenSet; }
  template <typename SourceServerIDsT = Aws::Vector<Aws::String>>
  void SetSourceServerIDs(SourceServerIDsT&& value) {
    m_sourceServerIDsHasBeenSet = true;
    m_sourceServerIDs = std::forward<SourceServerIDsT>(value);
  }
  template <typename SourceServerIDsT = Aws::Vector<Aws::String>>
  DisassociateSourceServersRequest& WithSourceServerIDs(SourceServerIDsT&& value) {
    SetSourceServerIDs(std::forward<SourceServerIDsT>(value));
    return *this;
  }
  template <typename SourceServerIDsT = Aws::String>
  DisassociateSourceServersRequest& AddSourceServerIDs(SourceServerIDsT&& value) {
    m_sourceServerIDsHasBeenSet = true;
    m_sourceServerIDs.emplace_back(std::forward<SourceServerIDsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountID;
  bool m_accountIDHasBeenSet = false;

  Aws::String m_applicationID;
  bool m_applicationIDHasBeenSet = false;

  Aws::Vector<Aws::String> m_sourceServerIDs;
  bool m_sourceServerIDsHasBeenSet = false;
};

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
