﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class SetDefaultMessageFeedbackEnabledResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API SetDefaultMessageFeedbackEnabledResult() = default;
  AWS_PINPOINTSMSVOICEV2_API SetDefaultMessageFeedbackEnabledResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API SetDefaultMessageFeedbackEnabledResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The arn of the configuration set.</p>
   */
  inline const Aws::String& GetConfigurationSetArn() const { return m_configurationSetArn; }
  template <typename ConfigurationSetArnT = Aws::String>
  void SetConfigurationSetArn(ConfigurationSetArnT&& value) {
    m_configurationSetArnHasBeenSet = true;
    m_configurationSetArn = std::forward<ConfigurationSetArnT>(value);
  }
  template <typename ConfigurationSetArnT = Aws::String>
  SetDefaultMessageFeedbackEnabledResult& WithConfigurationSetArn(ConfigurationSetArnT&& value) {
    SetConfigurationSetArn(std::forward<ConfigurationSetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configuration.</p>
   */
  inline const Aws::String& GetConfigurationSetName() const { return m_configurationSetName; }
  template <typename ConfigurationSetNameT = Aws::String>
  void SetConfigurationSetName(ConfigurationSetNameT&& value) {
    m_configurationSetNameHasBeenSet = true;
    m_configurationSetName = std::forward<ConfigurationSetNameT>(value);
  }
  template <typename ConfigurationSetNameT = Aws::String>
  SetDefaultMessageFeedbackEnabledResult& WithConfigurationSetName(ConfigurationSetNameT&& value) {
    SetConfigurationSetName(std::forward<ConfigurationSetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>True if message feedback is enabled.</p>
   */
  inline bool GetMessageFeedbackEnabled() const { return m_messageFeedbackEnabled; }
  inline void SetMessageFeedbackEnabled(bool value) {
    m_messageFeedbackEnabledHasBeenSet = true;
    m_messageFeedbackEnabled = value;
  }
  inline SetDefaultMessageFeedbackEnabledResult& WithMessageFeedbackEnabled(bool value) {
    SetMessageFeedbackEnabled(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SetDefaultMessageFeedbackEnabledResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configurationSetArn;
  bool m_configurationSetArnHasBeenSet = false;

  Aws::String m_configurationSetName;
  bool m_configurationSetNameHasBeenSet = false;

  bool m_messageFeedbackEnabled{false};
  bool m_messageFeedbackEnabledHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
