﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Provides information about a request to create a message
 * template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TemplateCreateMessageBody">AWS
 * API Reference</a></p>
 */
class TemplateCreateMessageBody {
 public:
  AWS_PINPOINT_API TemplateCreateMessageBody() = default;
  AWS_PINPOINT_API TemplateCreateMessageBody(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API TemplateCreateMessageBody& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the message template that was created.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  TemplateCreateMessageBody& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The message that's returned from the API for the request to create the
   * message template.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  TemplateCreateMessageBody& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the request to create the message template.</p>
   */
  inline const Aws::String& GetRequestID() const { return m_requestID; }
  inline bool RequestIDHasBeenSet() const { return m_requestIDHasBeenSet; }
  template <typename RequestIDT = Aws::String>
  void SetRequestID(RequestIDT&& value) {
    m_requestIDHasBeenSet = true;
    m_requestID = std::forward<RequestIDT>(value);
  }
  template <typename RequestIDT = Aws::String>
  TemplateCreateMessageBody& WithRequestID(RequestIDT&& value) {
    SetRequestID(std::forward<RequestIDT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_message;
  bool m_messageHasBeenSet = false;

  Aws::String m_requestID;
  bool m_requestIDHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
