﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/schemas/Schemas_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Schemas {
namespace Model {
class DescribeSchemaResult {
 public:
  AWS_SCHEMAS_API DescribeSchemaResult() = default;
  AWS_SCHEMAS_API DescribeSchemaResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SCHEMAS_API DescribeSchemaResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The source of the schema definition.</p>
   */
  inline const Aws::String& GetContent() const { return m_content; }
  template <typename ContentT = Aws::String>
  void SetContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content = std::forward<ContentT>(value);
  }
  template <typename ContentT = Aws::String>
  DescribeSchemaResult& WithContent(ContentT&& value) {
    SetContent(std::forward<ContentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the schema.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeSchemaResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that schema was modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModified() const { return m_lastModified; }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  void SetLastModified(LastModifiedT&& value) {
    m_lastModifiedHasBeenSet = true;
    m_lastModified = std::forward<LastModifiedT>(value);
  }
  template <typename LastModifiedT = Aws::Utils::DateTime>
  DescribeSchemaResult& WithLastModified(LastModifiedT&& value) {
    SetLastModified(std::forward<LastModifiedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the schema.</p>
   */
  inline const Aws::String& GetSchemaArn() const { return m_schemaArn; }
  template <typename SchemaArnT = Aws::String>
  void SetSchemaArn(SchemaArnT&& value) {
    m_schemaArnHasBeenSet = true;
    m_schemaArn = std::forward<SchemaArnT>(value);
  }
  template <typename SchemaArnT = Aws::String>
  DescribeSchemaResult& WithSchemaArn(SchemaArnT&& value) {
    SetSchemaArn(std::forward<SchemaArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  DescribeSchemaResult& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version number of the schema</p>
   */
  inline const Aws::String& GetSchemaVersion() const { return m_schemaVersion; }
  template <typename SchemaVersionT = Aws::String>
  void SetSchemaVersion(SchemaVersionT&& value) {
    m_schemaVersionHasBeenSet = true;
    m_schemaVersion = std::forward<SchemaVersionT>(value);
  }
  template <typename SchemaVersionT = Aws::String>
  DescribeSchemaResult& WithSchemaVersion(SchemaVersionT&& value) {
    SetSchemaVersion(std::forward<SchemaVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags associated with the resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  DescribeSchemaResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  DescribeSchemaResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the schema.</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  DescribeSchemaResult& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date the schema version was created.</p>
   */
  inline const Aws::Utils::DateTime& GetVersionCreatedDate() const { return m_versionCreatedDate; }
  template <typename VersionCreatedDateT = Aws::Utils::DateTime>
  void SetVersionCreatedDate(VersionCreatedDateT&& value) {
    m_versionCreatedDateHasBeenSet = true;
    m_versionCreatedDate = std::forward<VersionCreatedDateT>(value);
  }
  template <typename VersionCreatedDateT = Aws::Utils::DateTime>
  DescribeSchemaResult& WithVersionCreatedDate(VersionCreatedDateT&& value) {
    SetVersionCreatedDate(std::forward<VersionCreatedDateT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeSchemaResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_content;
  bool m_contentHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_lastModified{};
  bool m_lastModifiedHasBeenSet = false;

  Aws::String m_schemaArn;
  bool m_schemaArnHasBeenSet = false;

  Aws::String m_schemaName;
  bool m_schemaNameHasBeenSet = false;

  Aws::String m_schemaVersion;
  bool m_schemaVersionHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_type;
  bool m_typeHasBeenSet = false;

  Aws::Utils::DateTime m_versionCreatedDate{};
  bool m_versionCreatedDateHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
