﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/ConnectorStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {
class CreateConnectorV2Result {
 public:
  AWS_SECURITYHUB_API CreateConnectorV2Result() = default;
  AWS_SECURITYHUB_API CreateConnectorV2Result(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SECURITYHUB_API CreateConnectorV2Result& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the connectorV2.</p>
   */
  inline const Aws::String& GetConnectorArn() const { return m_connectorArn; }
  template <typename ConnectorArnT = Aws::String>
  void SetConnectorArn(ConnectorArnT&& value) {
    m_connectorArnHasBeenSet = true;
    m_connectorArn = std::forward<ConnectorArnT>(value);
  }
  template <typename ConnectorArnT = Aws::String>
  CreateConnectorV2Result& WithConnectorArn(ConnectorArnT&& value) {
    SetConnectorArn(std::forward<ConnectorArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The UUID of the connectorV2 to identify connectorV2 resource.</p>
   */
  inline const Aws::String& GetConnectorId() const { return m_connectorId; }
  template <typename ConnectorIdT = Aws::String>
  void SetConnectorId(ConnectorIdT&& value) {
    m_connectorIdHasBeenSet = true;
    m_connectorId = std::forward<ConnectorIdT>(value);
  }
  template <typename ConnectorIdT = Aws::String>
  CreateConnectorV2Result& WithConnectorId(ConnectorIdT&& value) {
    SetConnectorId(std::forward<ConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Url provide to customers for OAuth auth code flow.</p>
   */
  inline const Aws::String& GetAuthUrl() const { return m_authUrl; }
  template <typename AuthUrlT = Aws::String>
  void SetAuthUrl(AuthUrlT&& value) {
    m_authUrlHasBeenSet = true;
    m_authUrl = std::forward<AuthUrlT>(value);
  }
  template <typename AuthUrlT = Aws::String>
  CreateConnectorV2Result& WithAuthUrl(AuthUrlT&& value) {
    SetAuthUrl(std::forward<AuthUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the connectorV2.</p>
   */
  inline ConnectorStatus GetConnectorStatus() const { return m_connectorStatus; }
  inline void SetConnectorStatus(ConnectorStatus value) {
    m_connectorStatusHasBeenSet = true;
    m_connectorStatus = value;
  }
  inline CreateConnectorV2Result& WithConnectorStatus(ConnectorStatus value) {
    SetConnectorStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateConnectorV2Result& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectorArn;
  bool m_connectorArnHasBeenSet = false;

  Aws::String m_connectorId;
  bool m_connectorIdHasBeenSet = false;

  Aws::String m_authUrl;
  bool m_authUrlHasBeenSet = false;

  ConnectorStatus m_connectorStatus{ConnectorStatus::NOT_SET};
  bool m_connectorStatusHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
