﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/shield/Shield_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Shield {
namespace Model {
class CreateProtectionResult {
 public:
  AWS_SHIELD_API CreateProtectionResult() = default;
  AWS_SHIELD_API CreateProtectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SHIELD_API CreateProtectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier (ID) for the <a>Protection</a> object that is
   * created.</p>
   */
  inline const Aws::String& GetProtectionId() const { return m_protectionId; }
  template <typename ProtectionIdT = Aws::String>
  void SetProtectionId(ProtectionIdT&& value) {
    m_protectionIdHasBeenSet = true;
    m_protectionId = std::forward<ProtectionIdT>(value);
  }
  template <typename ProtectionIdT = Aws::String>
  CreateProtectionResult& WithProtectionId(ProtectionIdT&& value) {
    SetProtectionId(std::forward<ProtectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateProtectionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_protectionId;
  bool m_protectionIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Shield
}  // namespace Aws
