﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/tnb/Tnb_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace tnb {
namespace Model {
class InstantiateSolNetworkInstanceResult {
 public:
  AWS_TNB_API InstantiateSolNetworkInstanceResult() = default;
  AWS_TNB_API InstantiateSolNetworkInstanceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TNB_API InstantiateSolNetworkInstanceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the network operation.</p>
   */
  inline const Aws::String& GetNsLcmOpOccId() const { return m_nsLcmOpOccId; }
  template <typename NsLcmOpOccIdT = Aws::String>
  void SetNsLcmOpOccId(NsLcmOpOccIdT&& value) {
    m_nsLcmOpOccIdHasBeenSet = true;
    m_nsLcmOpOccId = std::forward<NsLcmOpOccIdT>(value);
  }
  template <typename NsLcmOpOccIdT = Aws::String>
  InstantiateSolNetworkInstanceResult& WithNsLcmOpOccId(NsLcmOpOccIdT&& value) {
    SetNsLcmOpOccId(std::forward<NsLcmOpOccIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A tag is a label that you assign to an Amazon Web Services resource. Each tag
   * consists of a key and an optional value. When you use this API, the tags are
   * only applied to the network operation that is created. These tags are not
   * applied to the network instance. Use tags to search and filter your resources or
   * track your Amazon Web Services costs.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  InstantiateSolNetworkInstanceResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  InstantiateSolNetworkInstanceResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  InstantiateSolNetworkInstanceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nsLcmOpOccId;
  bool m_nsLcmOpOccIdHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace tnb
}  // namespace Aws
