﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/waf/WAF_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WAF {
namespace Model {

/**
 *  <p>This is <b>AWS WAF Classic</b> documentation. For more information,
 * see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
 * WAF Classic</a> in the developer guide.</p> <p> <b>For the latest version of AWS
 * WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS
 * WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of
 * endpoints for regional and global use. </p>  <p>Returned by
 * <a>ListRegexPatternSets</a>. Each <code>RegexPatternSetSummary</code> object
 * includes the <code>Name</code> and <code>RegexPatternSetId</code> for one
 * <a>RegexPatternSet</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/RegexPatternSetSummary">AWS
 * API Reference</a></p>
 */
class RegexPatternSetSummary {
 public:
  AWS_WAF_API RegexPatternSetSummary() = default;
  AWS_WAF_API RegexPatternSetSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_WAF_API RegexPatternSetSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WAF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You
   * use <code>RegexPatternSetId</code> to get information about a
   * <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a
   * <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a
   * <code>RegexPatternSet</code> from AWS WAF.</p> <p>
   * <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and
   * by <a>ListRegexPatternSets</a>.</p>
   */
  inline const Aws::String& GetRegexPatternSetId() const { return m_regexPatternSetId; }
  inline bool RegexPatternSetIdHasBeenSet() const { return m_regexPatternSetIdHasBeenSet; }
  template <typename RegexPatternSetIdT = Aws::String>
  void SetRegexPatternSetId(RegexPatternSetIdT&& value) {
    m_regexPatternSetIdHasBeenSet = true;
    m_regexPatternSetId = std::forward<RegexPatternSetIdT>(value);
  }
  template <typename RegexPatternSetIdT = Aws::String>
  RegexPatternSetSummary& WithRegexPatternSetId(RegexPatternSetIdT&& value) {
    SetRegexPatternSetId(std::forward<RegexPatternSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A friendly name or description of the <a>RegexPatternSet</a>. You can't
   * change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  RegexPatternSetSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_regexPatternSetId;
  bool m_regexPatternSetIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAF
}  // namespace Aws
