﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/BlockDeviceMapping.h>
#include <aws/ec2/model/IamInstanceProfileSpecification.h>
#include <aws/ec2/model/InstanceNetworkInterfaceSpecification.h>
#include <aws/ec2/model/InstanceType.h>
#include <aws/ec2/model/RunInstancesMonitoringEnabled.h>
#include <aws/ec2/model/SpotPlacement.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes the launch specification for an instance.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotLaunchSpecification">AWS
 * API Reference</a></p>
 */
class RequestSpotLaunchSpecification {
 public:
  AWS_EC2_API RequestSpotLaunchSpecification() = default;
  AWS_EC2_API RequestSpotLaunchSpecification(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API RequestSpotLaunchSpecification& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The IDs of the security groups.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
  inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds = std::forward<SecurityGroupIdsT>(value);
  }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  RequestSpotLaunchSpecification& WithSecurityGroupIds(SecurityGroupIdsT&& value) {
    SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  template <typename SecurityGroupIdsT = Aws::String>
  RequestSpotLaunchSpecification& AddSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Not supported.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroups() const { return m_securityGroups; }
  inline bool SecurityGroupsHasBeenSet() const { return m_securityGroupsHasBeenSet; }
  template <typename SecurityGroupsT = Aws::Vector<Aws::String>>
  void SetSecurityGroups(SecurityGroupsT&& value) {
    m_securityGroupsHasBeenSet = true;
    m_securityGroups = std::forward<SecurityGroupsT>(value);
  }
  template <typename SecurityGroupsT = Aws::Vector<Aws::String>>
  RequestSpotLaunchSpecification& WithSecurityGroups(SecurityGroupsT&& value) {
    SetSecurityGroups(std::forward<SecurityGroupsT>(value));
    return *this;
  }
  template <typename SecurityGroupsT = Aws::String>
  RequestSpotLaunchSpecification& AddSecurityGroups(SecurityGroupsT&& value) {
    m_securityGroupsHasBeenSet = true;
    m_securityGroups.emplace_back(std::forward<SecurityGroupsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Deprecated.</p>
   */
  inline const Aws::String& GetAddressingType() const { return m_addressingType; }
  inline bool AddressingTypeHasBeenSet() const { return m_addressingTypeHasBeenSet; }
  template <typename AddressingTypeT = Aws::String>
  void SetAddressingType(AddressingTypeT&& value) {
    m_addressingTypeHasBeenSet = true;
    m_addressingType = std::forward<AddressingTypeT>(value);
  }
  template <typename AddressingTypeT = Aws::String>
  RequestSpotLaunchSpecification& WithAddressingType(AddressingTypeT&& value) {
    SetAddressingType(std::forward<AddressingTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The block device mapping entries. You can't specify both a snapshot ID and an
   * encryption value. This is because only blank volumes can be encrypted on
   * creation. If a snapshot is the basis for a volume, it is not blank and its
   * encryption status is used for the volume encryption status.</p>
   */
  inline const Aws::Vector<BlockDeviceMapping>& GetBlockDeviceMappings() const { return m_blockDeviceMappings; }
  inline bool BlockDeviceMappingsHasBeenSet() const { return m_blockDeviceMappingsHasBeenSet; }
  template <typename BlockDeviceMappingsT = Aws::Vector<BlockDeviceMapping>>
  void SetBlockDeviceMappings(BlockDeviceMappingsT&& value) {
    m_blockDeviceMappingsHasBeenSet = true;
    m_blockDeviceMappings = std::forward<BlockDeviceMappingsT>(value);
  }
  template <typename BlockDeviceMappingsT = Aws::Vector<BlockDeviceMapping>>
  RequestSpotLaunchSpecification& WithBlockDeviceMappings(BlockDeviceMappingsT&& value) {
    SetBlockDeviceMappings(std::forward<BlockDeviceMappingsT>(value));
    return *this;
  }
  template <typename BlockDeviceMappingsT = BlockDeviceMapping>
  RequestSpotLaunchSpecification& AddBlockDeviceMappings(BlockDeviceMappingsT&& value) {
    m_blockDeviceMappingsHasBeenSet = true;
    m_blockDeviceMappings.emplace_back(std::forward<BlockDeviceMappingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the instance is optimized for EBS I/O. This optimization
   * provides dedicated throughput to Amazon EBS and an optimized configuration stack
   * to provide optimal EBS I/O performance. This optimization isn't available with
   * all instance types. Additional usage charges apply when using an EBS Optimized
   * instance.</p> <p>Default: <code>false</code> </p>
   */
  inline bool GetEbsOptimized() const { return m_ebsOptimized; }
  inline bool EbsOptimizedHasBeenSet() const { return m_ebsOptimizedHasBeenSet; }
  inline void SetEbsOptimized(bool value) {
    m_ebsOptimizedHasBeenSet = true;
    m_ebsOptimized = value;
  }
  inline RequestSpotLaunchSpecification& WithEbsOptimized(bool value) {
    SetEbsOptimized(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IAM instance profile.</p>
   */
  inline const IamInstanceProfileSpecification& GetIamInstanceProfile() const { return m_iamInstanceProfile; }
  inline bool IamInstanceProfileHasBeenSet() const { return m_iamInstanceProfileHasBeenSet; }
  template <typename IamInstanceProfileT = IamInstanceProfileSpecification>
  void SetIamInstanceProfile(IamInstanceProfileT&& value) {
    m_iamInstanceProfileHasBeenSet = true;
    m_iamInstanceProfile = std::forward<IamInstanceProfileT>(value);
  }
  template <typename IamInstanceProfileT = IamInstanceProfileSpecification>
  RequestSpotLaunchSpecification& WithIamInstanceProfile(IamInstanceProfileT&& value) {
    SetIamInstanceProfile(std::forward<IamInstanceProfileT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the AMI.</p>
   */
  inline const Aws::String& GetImageId() const { return m_imageId; }
  inline bool ImageIdHasBeenSet() const { return m_imageIdHasBeenSet; }
  template <typename ImageIdT = Aws::String>
  void SetImageId(ImageIdT&& value) {
    m_imageIdHasBeenSet = true;
    m_imageId = std::forward<ImageIdT>(value);
  }
  template <typename ImageIdT = Aws::String>
  RequestSpotLaunchSpecification& WithImageId(ImageIdT&& value) {
    SetImageId(std::forward<ImageIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance type. Only one instance type can be specified.</p>
   */
  inline InstanceType GetInstanceType() const { return m_instanceType; }
  inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
  inline void SetInstanceType(InstanceType value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = value;
  }
  inline RequestSpotLaunchSpecification& WithInstanceType(InstanceType value) {
    SetInstanceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the kernel.</p>
   */
  inline const Aws::String& GetKernelId() const { return m_kernelId; }
  inline bool KernelIdHasBeenSet() const { return m_kernelIdHasBeenSet; }
  template <typename KernelIdT = Aws::String>
  void SetKernelId(KernelIdT&& value) {
    m_kernelIdHasBeenSet = true;
    m_kernelId = std::forward<KernelIdT>(value);
  }
  template <typename KernelIdT = Aws::String>
  RequestSpotLaunchSpecification& WithKernelId(KernelIdT&& value) {
    SetKernelId(std::forward<KernelIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the key pair.</p>
   */
  inline const Aws::String& GetKeyName() const { return m_keyName; }
  inline bool KeyNameHasBeenSet() const { return m_keyNameHasBeenSet; }
  template <typename KeyNameT = Aws::String>
  void SetKeyName(KeyNameT&& value) {
    m_keyNameHasBeenSet = true;
    m_keyName = std::forward<KeyNameT>(value);
  }
  template <typename KeyNameT = Aws::String>
  RequestSpotLaunchSpecification& WithKeyName(KeyNameT&& value) {
    SetKeyName(std::forward<KeyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether basic or detailed monitoring is enabled for the
   * instance.</p> <p>Default: Disabled</p>
   */
  inline const RunInstancesMonitoringEnabled& GetMonitoring() const { return m_monitoring; }
  inline bool MonitoringHasBeenSet() const { return m_monitoringHasBeenSet; }
  template <typename MonitoringT = RunInstancesMonitoringEnabled>
  void SetMonitoring(MonitoringT&& value) {
    m_monitoringHasBeenSet = true;
    m_monitoring = std::forward<MonitoringT>(value);
  }
  template <typename MonitoringT = RunInstancesMonitoringEnabled>
  RequestSpotLaunchSpecification& WithMonitoring(MonitoringT&& value) {
    SetMonitoring(std::forward<MonitoringT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The network interfaces. If you specify a network interface, you must specify
   * subnet IDs and security group IDs using the network interface.</p>
   */
  inline const Aws::Vector<InstanceNetworkInterfaceSpecification>& GetNetworkInterfaces() const { return m_networkInterfaces; }
  inline bool NetworkInterfacesHasBeenSet() const { return m_networkInterfacesHasBeenSet; }
  template <typename NetworkInterfacesT = Aws::Vector<InstanceNetworkInterfaceSpecification>>
  void SetNetworkInterfaces(NetworkInterfacesT&& value) {
    m_networkInterfacesHasBeenSet = true;
    m_networkInterfaces = std::forward<NetworkInterfacesT>(value);
  }
  template <typename NetworkInterfacesT = Aws::Vector<InstanceNetworkInterfaceSpecification>>
  RequestSpotLaunchSpecification& WithNetworkInterfaces(NetworkInterfacesT&& value) {
    SetNetworkInterfaces(std::forward<NetworkInterfacesT>(value));
    return *this;
  }
  template <typename NetworkInterfacesT = InstanceNetworkInterfaceSpecification>
  RequestSpotLaunchSpecification& AddNetworkInterfaces(NetworkInterfacesT&& value) {
    m_networkInterfacesHasBeenSet = true;
    m_networkInterfaces.emplace_back(std::forward<NetworkInterfacesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The placement information for the instance.</p>
   */
  inline const SpotPlacement& GetPlacement() const { return m_placement; }
  inline bool PlacementHasBeenSet() const { return m_placementHasBeenSet; }
  template <typename PlacementT = SpotPlacement>
  void SetPlacement(PlacementT&& value) {
    m_placementHasBeenSet = true;
    m_placement = std::forward<PlacementT>(value);
  }
  template <typename PlacementT = SpotPlacement>
  RequestSpotLaunchSpecification& WithPlacement(PlacementT&& value) {
    SetPlacement(std::forward<PlacementT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the RAM disk.</p>
   */
  inline const Aws::String& GetRamdiskId() const { return m_ramdiskId; }
  inline bool RamdiskIdHasBeenSet() const { return m_ramdiskIdHasBeenSet; }
  template <typename RamdiskIdT = Aws::String>
  void SetRamdiskId(RamdiskIdT&& value) {
    m_ramdiskIdHasBeenSet = true;
    m_ramdiskId = std::forward<RamdiskIdT>(value);
  }
  template <typename RamdiskIdT = Aws::String>
  RequestSpotLaunchSpecification& WithRamdiskId(RamdiskIdT&& value) {
    SetRamdiskId(std::forward<RamdiskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the subnet in which to launch the instance.</p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  RequestSpotLaunchSpecification& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The base64-encoded user data that instances use when starting up. User data
   * is limited to 16 KB.</p>
   */
  inline const Aws::String& GetUserData() const { return m_userData; }
  inline bool UserDataHasBeenSet() const { return m_userDataHasBeenSet; }
  template <typename UserDataT = Aws::String>
  void SetUserData(UserDataT&& value) {
    m_userDataHasBeenSet = true;
    m_userData = std::forward<UserDataT>(value);
  }
  template <typename UserDataT = Aws::String>
  RequestSpotLaunchSpecification& WithUserData(UserDataT&& value) {
    SetUserData(std::forward<UserDataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_securityGroupIds;
  bool m_securityGroupIdsHasBeenSet = false;

  Aws::Vector<Aws::String> m_securityGroups;
  bool m_securityGroupsHasBeenSet = false;

  Aws::String m_addressingType;
  bool m_addressingTypeHasBeenSet = false;

  Aws::Vector<BlockDeviceMapping> m_blockDeviceMappings;
  bool m_blockDeviceMappingsHasBeenSet = false;

  bool m_ebsOptimized{false};
  bool m_ebsOptimizedHasBeenSet = false;

  IamInstanceProfileSpecification m_iamInstanceProfile;
  bool m_iamInstanceProfileHasBeenSet = false;

  Aws::String m_imageId;
  bool m_imageIdHasBeenSet = false;

  InstanceType m_instanceType{InstanceType::NOT_SET};
  bool m_instanceTypeHasBeenSet = false;

  Aws::String m_kernelId;
  bool m_kernelIdHasBeenSet = false;

  Aws::String m_keyName;
  bool m_keyNameHasBeenSet = false;

  RunInstancesMonitoringEnabled m_monitoring;
  bool m_monitoringHasBeenSet = false;

  Aws::Vector<InstanceNetworkInterfaceSpecification> m_networkInterfaces;
  bool m_networkInterfacesHasBeenSet = false;

  SpotPlacement m_placement;
  bool m_placementHasBeenSet = false;

  Aws::String m_ramdiskId;
  bool m_ramdiskIdHasBeenSet = false;

  Aws::String m_subnetId;
  bool m_subnetIdHasBeenSet = false;

  Aws::String m_userData;
  bool m_userDataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
