# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "databoxedge device share show",
)
class Show(AAZCommand):
    """Show share.

    :example: Show share
        az databoxedge device share show -g rg -n share-name --device-name name
    """

    _aaz_info = {
        "version": "2023-07-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.databoxedge/databoxedgedevices/{}/shares/{}", "2023-07-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.device_name = AAZStrArg(
            options=["--device-name"],
            help="The device name.",
            required=True,
            id_part="name",
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The share name.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SharesGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SharesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/shares/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "deviceName", self.ctx.args.device_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"required": True, "client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.access_protocol = AAZStrType(
                serialized_name="accessProtocol",
                flags={"required": True},
            )
            properties.azure_container_info = AAZObjectType(
                serialized_name="azureContainerInfo",
            )
            properties.client_access_rights = AAZListType(
                serialized_name="clientAccessRights",
            )
            properties.data_policy = AAZStrType(
                serialized_name="dataPolicy",
            )
            properties.description = AAZStrType()
            properties.monitoring_status = AAZStrType(
                serialized_name="monitoringStatus",
                flags={"required": True},
            )
            properties.refresh_details = AAZObjectType(
                serialized_name="refreshDetails",
            )
            properties.share_mappings = AAZListType(
                serialized_name="shareMappings",
                flags={"read_only": True},
            )
            properties.share_status = AAZStrType(
                serialized_name="shareStatus",
                flags={"required": True},
            )
            properties.user_access_rights = AAZListType(
                serialized_name="userAccessRights",
            )

            azure_container_info = cls._schema_on_200.properties.azure_container_info
            azure_container_info.container_name = AAZStrType(
                serialized_name="containerName",
                flags={"required": True},
            )
            azure_container_info.data_format = AAZStrType(
                serialized_name="dataFormat",
                flags={"required": True},
            )
            azure_container_info.storage_account_credential_id = AAZStrType(
                serialized_name="storageAccountCredentialId",
                flags={"required": True},
            )

            client_access_rights = cls._schema_on_200.properties.client_access_rights
            client_access_rights.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.client_access_rights.Element
            _element.access_permission = AAZStrType(
                serialized_name="accessPermission",
                flags={"required": True},
            )
            _element.client = AAZStrType(
                flags={"required": True},
            )

            refresh_details = cls._schema_on_200.properties.refresh_details
            refresh_details.error_manifest_file = AAZStrType(
                serialized_name="errorManifestFile",
            )
            refresh_details.in_progress_refresh_job_id = AAZStrType(
                serialized_name="inProgressRefreshJobId",
            )
            refresh_details.last_completed_refresh_job_time_in_utc = AAZStrType(
                serialized_name="lastCompletedRefreshJobTimeInUTC",
            )
            refresh_details.last_job = AAZStrType(
                serialized_name="lastJob",
            )

            share_mappings = cls._schema_on_200.properties.share_mappings
            share_mappings.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.share_mappings.Element
            _element.mount_point = AAZStrType(
                serialized_name="mountPoint",
                flags={"read_only": True},
            )
            _element.mount_type = AAZStrType(
                serialized_name="mountType",
                flags={"read_only": True},
            )
            _element.role_id = AAZStrType(
                serialized_name="roleId",
                flags={"read_only": True},
            )
            _element.role_type = AAZStrType(
                serialized_name="roleType",
                flags={"read_only": True},
            )
            _element.share_id = AAZStrType(
                serialized_name="shareId",
                flags={"required": True},
            )

            user_access_rights = cls._schema_on_200.properties.user_access_rights
            user_access_rights.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.user_access_rights.Element
            _element.access_type = AAZStrType(
                serialized_name="accessType",
                flags={"required": True},
            )
            _element.user_id = AAZStrType(
                serialized_name="userId",
                flags={"required": True},
            )

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""


__all__ = ["Show"]
