/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import proguard.gui.GUIResources;

abstract class ListPanel
extends JPanel {
    protected final DefaultListModel listModel = new DefaultListModel();
    protected final JList list = new JList(this.listModel);
    protected int firstSelectionButton = 2;

    protected ListPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints listConstraints = new GridBagConstraints();
        listConstraints.gridheight = 0;
        listConstraints.fill = 1;
        listConstraints.weightx = 1.0;
        listConstraints.weighty = 1.0;
        listConstraints.anchor = 18;
        listConstraints.insets = new Insets(0, 2, 0, 2);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListPanel.this.enableSelectionButtons();
            }
        });
        this.add((Component)new JScrollPane(this.list), listConstraints);
    }

    protected void addRemoveButton() {
        JButton removeButton = new JButton(ListPanel.msg("remove"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.removeElementsAt(ListPanel.this.list.getSelectedIndices());
            }
        });
        this.addButton(ListPanel.tip(removeButton, "removeTip"));
    }

    protected void addUpButton() {
        JButton upButton = new JButton(ListPanel.msg("moveUp"));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedIndices = ListPanel.this.list.getSelectedIndices();
                if (selectedIndices.length > 0 && selectedIndices[0] > 0) {
                    ListPanel.this.moveElementsAt(selectedIndices, -1);
                }
            }
        });
        this.addButton(ListPanel.tip(upButton, "moveUpTip"));
    }

    protected void addDownButton() {
        JButton downButton = new JButton(ListPanel.msg("moveDown"));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedIndices = ListPanel.this.list.getSelectedIndices();
                if (selectedIndices.length > 0 && selectedIndices[selectedIndices.length - 1] < ListPanel.this.listModel.getSize() - 1) {
                    ListPanel.this.moveElementsAt(selectedIndices, 1);
                }
            }
        });
        this.addButton(ListPanel.tip(downButton, "moveDownTip"));
    }

    public void addCopyToPanelButton(String buttonTextKey, String tipKey, final ListPanel panel) {
        JButton moveButton = new JButton(ListPanel.msg(buttonTextKey));
        moveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedIndices = ListPanel.this.list.getSelectedIndices();
                Object[] selectedElements = ListPanel.this.list.getSelectedValues();
                ListPanel.this.removeElementsAt(selectedIndices);
                panel.addElements(selectedElements);
            }
        });
        this.addButton(ListPanel.tip(moveButton, tipKey));
    }

    protected void addButton(JComponent button) {
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridwidth = 0;
        buttonConstraints.fill = 2;
        buttonConstraints.anchor = 18;
        buttonConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)button, buttonConstraints);
    }

    public List getButtons() {
        ArrayList<Component> list = new ArrayList<Component>(this.getComponentCount() - 1);
        for (int index = 1; index < this.getComponentCount(); ++index) {
            list.add(this.getComponent(index));
        }
        return list;
    }

    protected void addElement(Object element) {
        this.listModel.addElement(element);
        this.list.setSelectedIndex(this.listModel.size() - 1);
    }

    protected void addElements(Object[] elements) {
        for (int index = 0; index < elements.length; ++index) {
            this.listModel.addElement(elements[index]);
        }
        int[] selectedIndices = new int[elements.length];
        for (int index = 0; index < selectedIndices.length; ++index) {
            selectedIndices[index] = this.listModel.size() - selectedIndices.length + index;
        }
        this.list.setSelectedIndices(selectedIndices);
    }

    protected void moveElementsAt(int[] indices, int offset) {
        Object[] selectedElements = this.list.getSelectedValues();
        this.removeElementsAt(indices);
        int index = 0;
        while (index < indices.length) {
            int n = index++;
            indices[n] = indices[n] + offset;
        }
        this.insertElementsAt(selectedElements, indices);
    }

    protected void insertElementsAt(Object[] elements, int[] indices) {
        for (int index = 0; index < elements.length; ++index) {
            this.listModel.insertElementAt(elements[index], indices[index]);
        }
        this.list.setSelectedIndices(indices);
    }

    protected void setElementAt(Object element, int index) {
        this.listModel.setElementAt(element, index);
        this.list.setSelectedIndex(index);
    }

    protected void setElementsAt(Object[] elements, int[] indices) {
        for (int index = 0; index < elements.length; ++index) {
            this.listModel.setElementAt(elements[index], indices[index]);
        }
        this.list.setSelectedIndices(indices);
    }

    protected void removeElementsAt(int[] indices) {
        for (int index = indices.length - 1; index >= 0; --index) {
            this.listModel.removeElementAt(indices[index]);
        }
        this.list.clearSelection();
        this.enableSelectionButtons();
    }

    protected void removeAllElements() {
        this.listModel.removeAllElements();
        this.enableSelectionButtons();
    }

    protected void enableSelectionButtons() {
        boolean selected = !this.list.isSelectionEmpty();
        for (int index = this.firstSelectionButton; index < this.getComponentCount(); ++index) {
            this.getComponent(index).setEnabled(selected);
        }
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ListPanel.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

