/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DiscoveryImages {
    private static final String T_OVR_32 = "ovr32";
    private static final String T_OBJ_16 = "obj16";
    private static final String T_WIZBAN = "wizban";
    private static final URL baseURL = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.discovery").getEntry("/icons/");
    public static final ImageDescriptor OVERLAY_WARNING_32 = DiscoveryImages.create("ovr32", "message_warning.svg");
    public static final ImageDescriptor BANNER_DISOVERY = DiscoveryImages.create("wizban", "banner-discovery.svg");
    public static final ImageDescriptor IU_AVAILABLE = DiscoveryImages.create("obj16", "iu_disabled_obj.svg");
    public static final ImageDescriptor IU_INSTALLED = DiscoveryImages.create("obj16", "iu_obj.svg");
    public static final ImageDescriptor IU_UPDATABLE = DiscoveryImages.create("obj16", "iu_update_obj.svg");
    public static final ImageDescriptor MESSAGE_INFO = DiscoveryImages.create("obj16", "message_info.svg");
    private static ImageRegistry imageRegistry;

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)DiscoveryImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry reg = DiscoveryImages.getImageRegistry();
        Image image = reg.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            reg.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }
}

