/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;

public class JComboBoxFactory {
    public static final int MAXIMUM_ROW_COUNT = 10;

    public static <T> JComboBox<T> create() {
        JComboBox c = new JComboBox();
        c.setMaximumRowCount(10);
        return c;
    }

    public static <T> JComboBox<T> create(ComboBoxModel<T> aModel) {
        JComboBoxWithAdaptingSize c = new JComboBoxWithAdaptingSize(aModel);
        c.setMaximumRowCount(10);
        return c;
    }

    public static <T> JComboBox<T> create(T[] items) {
        JComboBox<T> c = new JComboBox<T>(items);
        c.setMaximumRowCount(10);
        return c;
    }

    public static <T> JComboBox<T> create(Vector<T> items) {
        JComboBox<T> c = new JComboBox<T>(items);
        c.setMaximumRowCount(10);
        return c;
    }

    private static class JComboBoxWithAdaptingSize<T>
    extends JComboBox<T> {
        private static final long serialVersionUID = 1L;
        private boolean preferredSizeCalculationInProgress;

        private JComboBoxWithAdaptingSize(ComboBoxModel<T> aModel) {
            super(aModel);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            super.intervalAdded(e);
            this.adaptSize();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            super.contentsChanged(e);
            this.adaptSize();
        }

        private void adaptSize() {
            if (this.getPrototypeDisplayValue() == null) {
                this.revalidate();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            this.preferredSizeCalculationInProgress = true;
            try {
                Dimension dimension = super.getPreferredSize();
                return dimension;
            }
            finally {
                this.preferredSizeCalculationInProgress = false;
            }
        }

        @Override
        public boolean isEditable() {
            return !this.preferredSizeCalculationInProgress && super.isEditable();
        }
    }
}

