/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.util.Locale;
import org.freeplane.features.format.DateFormatParser;
import org.freeplane.features.format.DecimalFormatParser;
import org.freeplane.features.format.IsoDateParser;
import org.freeplane.features.format.NumberLiteralParser;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class Parser {
    public static final String STYLE_NUMBERLITERAL = "numberliteral";
    public static final String STYLE_DECIMAL = "decimal";
    public static final String STYLE_ISODATE = "isodate";
    public static final String STYLE_DATE = "date";
    private final String style;
    private final String type;
    private final String format;
    private String comment;

    public Parser(String style, String type, String format, String comment) {
        this.style = style;
        this.type = type;
        this.format = format;
        this.comment = comment;
    }

    public Parser(String style, String type, String format) {
        this(style, type, format, null);
    }

    abstract Object parse(String var1);

    public static Parser createParser(String style, String type, String format, Locale locale, String comment) {
        Parser parser;
        if (style.equals(STYLE_NUMBERLITERAL)) {
            parser = new NumberLiteralParser();
        } else if (style.equals(STYLE_DECIMAL)) {
            parser = new DecimalFormatParser(locale);
        } else if (style.equals(STYLE_ISODATE)) {
            parser = new IsoDateParser();
        } else if (style.equals(STYLE_DATE)) {
            parser = new DateFormatParser(format, type);
        } else {
            throw new IllegalArgumentException("illegal parser style " + style);
        }
        parser.setComment(comment);
        return parser;
    }

    public XMLElement toXml() {
        XMLElement xmlElement = new XMLElement("parser");
        xmlElement.setAttribute("type", this.getType());
        xmlElement.setAttribute("style", this.getStyle());
        if (this.getFormat() != null) {
            xmlElement.setAttribute("format", this.getFormat());
        }
        if (this.getComment() != null) {
            xmlElement.setAttribute("comment", this.getComment());
        }
        return xmlElement;
    }

    public String getStyle() {
        return this.style;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

