/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import java.util.Objects;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;

public class LocationModel
implements IExtension {
    public static final Quantity<LengthUnit> DEFAULT_HGAP = new Quantity(14.0, (Enum)LengthUnit.pt);
    public static final int DEFAULT_HGAP_PX = DEFAULT_HGAP.toBaseUnitsRounded();
    public static Quantity<LengthUnit> DEFAULT_SHIFT_Y = new Quantity(0.0, (Enum)LengthUnit.pt);
    public static Quantity<LengthUnit> DEFAULT_VGAP = new Quantity(2.0, (Enum)LengthUnit.pt);
    public static final int DEFAULT_VGAP_PX = DEFAULT_VGAP.toBaseUnitsRounded();
    public static final LocationModel NULL_LOCATION = new LocationModel(){

        @Override
        public void setHGap(Quantity<LengthUnit> gap) {
            if (gap != this.getHGap()) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void setBaseHGap(Quantity<LengthUnit> gap) {
            if (gap != this.getBaseHGap()) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void setShiftY(Quantity<LengthUnit> shiftY) {
            if (shiftY != this.getShiftY()) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void setVGap(Quantity<LengthUnit> gap) {
            if (gap != this.getVGap()) {
                throw new IllegalArgumentException();
            }
        }
    };
    private Quantity<LengthUnit> hGap = DEFAULT_HGAP;
    private Quantity<LengthUnit> baseHGap = DEFAULT_HGAP;
    private Quantity<LengthUnit> shiftY = DEFAULT_SHIFT_Y;
    private Quantity<LengthUnit> vGap = DEFAULT_VGAP;

    public static LocationModel createLocationModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        if (location == null) {
            location = new LocationModel();
            node.addExtension(location);
        }
        return location;
    }

    public static LocationModel getModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        return location != null ? location : NULL_LOCATION;
    }

    public Quantity<LengthUnit> getHGap() {
        return this.hGap;
    }

    public Quantity<LengthUnit> getBaseHGap() {
        return this.baseHGap;
    }

    public Quantity<LengthUnit> getShiftY() {
        return this.shiftY;
    }

    public Quantity<LengthUnit> getVGap() {
        return this.vGap;
    }

    public void setHGap(Quantity<LengthUnit> gap) {
        Objects.requireNonNull(gap);
        this.hGap = gap;
    }

    public void setBaseHGap(Quantity<LengthUnit> baseHGap) {
        Objects.requireNonNull(baseHGap);
        this.baseHGap = baseHGap;
    }

    public void setShiftY(Quantity<LengthUnit> shiftY) {
        Objects.requireNonNull(shiftY);
        this.shiftY = shiftY;
    }

    public void setVGap(Quantity<LengthUnit> gap) {
        Objects.requireNonNull(gap);
        this.vGap = gap.toBaseUnits() >= 0.0 ? gap : new Quantity(0.0, (Enum)((LengthUnit)gap.unit));
    }
}

