/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.commons.lang.StringEscapeUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

class ClickableImageCreator {
    Vector<AreaHolder> area = new Vector();
    private Rectangle innerBounds;
    private final MapView mapView;
    private final String regExpLinkReplacement;
    private final NodeModel root;

    ClickableImageCreator(NodeModel root, ModeController modeController, String regExpLinkReplacement) {
        this.root = root;
        this.regExpLinkReplacement = regExpLinkReplacement;
        this.mapView = (MapView)modeController.getController().getMapViewManager().getMapViewComponent();
        if (this.mapView != null) {
            this.mapView.preparePrinting();
            this.innerBounds = this.mapView.getInnerBounds();
        } else {
            this.innerBounds = new Rectangle(0, 0, 100, 100);
        }
        this.createArea();
        if (this.mapView != null) {
            this.mapView.endPrinting();
        }
    }

    private void createArea() {
        this.createArea(this.root);
    }

    private void createArea(NodeModel node) {
        NodeView nodeView = this.mapView.getNodeView(node);
        if (nodeView != null) {
            AreaHolder holder = new AreaHolder();
            holder.title = TextController.getController().getShortPlainText(node);
            holder.alt = TextController.getController().getShortPlainText(node);
            holder.href = node.createID();
            Point contentXY = this.mapView.getNodeContentLocation(nodeView);
            JComponent content = nodeView.getContent();
            holder.coordinates.x = (int)((double)contentXY.x - this.innerBounds.getMinX());
            holder.coordinates.y = (int)((double)contentXY.y - this.innerBounds.getMinY());
            holder.coordinates.width = content.getWidth();
            holder.coordinates.height = content.getHeight();
            this.area.add(holder);
            for (NodeModel child : node.getChildren()) {
                this.createArea(child);
            }
        }
    }

    public String generateHtml() {
        StringBuilder htmlArea = new StringBuilder();
        for (AreaHolder holder : this.area) {
            htmlArea.append("<area shape=\"" + holder.shape + "\" href=\"#" + holder.href.replaceFirst("^(.*)$", this.regExpLinkReplacement) + "\" alt=\"" + StringEscapeUtils.escapeHtml((String)holder.alt) + "\" title=\"" + StringEscapeUtils.escapeHtml((String)holder.title) + "\" coords=\"" + holder.coordinates.x + "," + holder.coordinates.y + "," + (holder.coordinates.width + holder.coordinates.x) + "," + (holder.coordinates.height + holder.coordinates.y) + "\" />\n");
        }
        return htmlArea.toString();
    }

    public static class AreaHolder {
        String alt;
        Rectangle coordinates = new Rectangle();
        String href;
        String shape = "rect";
        String title;
    }
}

