/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import javax.swing.JComponent;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewLayoutHelper;

class ContentSizeCalculator {
    static final int UNSET = -1;
    public static final Dimension ZERO = new Dimension(0, 0);
    public static ContentSizeCalculator INSTANCE = new ContentSizeCalculator();

    ContentSizeCalculator() {
    }

    Dimension calculateContentSize(NodeView view) {
        if (!view.isContentVisible()) {
            return ZERO;
        }
        JComponent content = view.getContent();
        Dimension contentSize = content.getPreferredSize();
        return contentSize;
    }

    Dimension calculateContentSize(NodeView view, int minimumWidth) {
        Dimension contentSize = this.calculateContentSize(view);
        if (contentSize.width > 0 && contentSize.height > 0 && minimumWidth != -1) {
            int maximumWidth = view.getMainView().getMaximumWidth();
            if (contentSize.width < minimumWidth && contentSize.width < maximumWidth) {
                contentSize.width = Math.min(minimumWidth, maximumWidth);
            }
        }
        return contentSize;
    }

    Dimension calculateContentSize(NodeViewLayoutHelper accessor) {
        return accessor.calculateContentSize();
    }
}

