/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public class ClassSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final String className;
    private Class<?> javaClass;

    ClassSelector(ClassLoader classLoader, String className) {
        this.className = className;
        this.classLoader = classLoader;
    }

    ClassSelector(Class<?> javaClass) {
        this.className = javaClass.getName();
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            Try tryToLoadClass = this.classLoader == null ? ReflectionSupport.tryToLoadClass((String)this.className) : ReflectionSupport.tryToLoadClass((String)this.className, (ClassLoader)this.classLoader);
            this.javaClass = (Class)tryToLoadClass.getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
        return this.javaClass;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSelector that = (ClassSelector)o;
        return Objects.equals(this.className, that.className);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("classLoader", (Object)this.classLoader).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("class", this.className));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "class";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<ClassSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectClass(identifier.getValue()));
        }
    }
}

