/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.DomainObjectCreationContext;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.TryCatchBlock;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasTypeParameters;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.SourceDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class DomainBuilders {
    private DomainBuilders() {
    }

    static <T extends HasDescription> Map<String, JavaAnnotation<T>> buildAnnotations(T owner, Set<JavaAnnotationBuilder> annotations, ImportedClasses importedClasses) {
        ImmutableMap.Builder<String, JavaAnnotation<T>> result = ImmutableMap.builder();
        for (JavaAnnotationBuilder annotationBuilder : annotations) {
            JavaAnnotation<T> javaAnnotation = annotationBuilder.build(owner, importedClasses);
            result.put(javaAnnotation.getRawType().getName(), javaAnnotation);
        }
        return result.build();
    }

    private static Set<JavaTypeVariable<?>> allTypeParametersInEnclosingContextOf(JavaCodeUnit codeUnit) {
        JavaClass declaringClass = codeUnit.getOwner();
        return FluentIterable.from(DomainBuilders.getTypeParametersOf(declaringClass)).append((Iterable<JavaTypeVariable<?>>)DomainBuilders.allTypeParametersInEnclosingContextOf(declaringClass)).toSet();
    }

    private static List<JavaTypeVariable<?>> getTypeParametersOf(HasTypeParameters<?> hasTypeParameters) {
        List<JavaTypeVariable<?>> result = hasTypeParameters.getTypeParameters();
        return result;
    }

    private static Set<JavaTypeVariable<?>> allTypeParametersInEnclosingContextOf(JavaClass javaClass) {
        HashSet result = new HashSet();
        while (javaClass.getEnclosingClass().isPresent()) {
            if (javaClass.getEnclosingCodeUnit().isPresent()) {
                result.addAll(javaClass.getEnclosingCodeUnit().get().getTypeParameters());
            }
            result.addAll(javaClass.getEnclosingClass().get().getTypeParameters());
            javaClass = javaClass.getEnclosingClass().get();
        }
        return result;
    }

    private static <OWNER> List<JavaType> buildJavaTypes(List<? extends JavaTypeCreationProcess<OWNER>> typeCreationProcesses, OWNER owner, Iterable<JavaTypeVariable<?>> allGenericParametersInContext, ImportedClasses classes) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (JavaTypeCreationProcess<OWNER> typeCreationProcess : typeCreationProcesses) {
            result.add(typeCreationProcess.finish(owner, allGenericParametersInContext, classes));
        }
        return result.build();
    }

    private static JavaClass getUnboundErasureType(List<JavaType> upperBounds, ImportedClasses importedClasses) {
        return upperBounds.size() > 0 ? upperBounds.get(0).toErasure() : importedClasses.getOrResolve(Object.class.getName());
    }

    public static CodeUnitAccessTargetBuilder<JavaConstructor, AccessTarget.ConstructorCallTarget> newConstructorCallTargetBuilder() {
        return (CodeUnitAccessTargetBuilder)new CodeUnitAccessTargetBuilder(DomainObjectCreationContext::createConstructorCallTarget).withName("<init>");
    }

    public static CodeUnitAccessTargetBuilder<JavaConstructor, AccessTarget.ConstructorReferenceTarget> newConstructorReferenceTargetBuilder() {
        return (CodeUnitAccessTargetBuilder)new CodeUnitAccessTargetBuilder(DomainObjectCreationContext::createConstructorReferenceTarget).withName("<init>");
    }

    public static CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodCallTarget> newMethodCallTargetBuilder() {
        return new CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodCallTarget>(DomainObjectCreationContext::createMethodCallTarget);
    }

    public static CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodReferenceTarget> newMethodReferenceTargetBuilder() {
        return new CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodReferenceTarget>(DomainObjectCreationContext::createMethodReferenceTarget);
    }

    @Internal
    public static final class JavaAnnotationBuilder {
        private JavaClassDescriptor type;
        private final Map<String, ValueBuilder> values = new LinkedHashMap<String, ValueBuilder>();
        private ImportedClasses importedClasses;

        JavaAnnotationBuilder() {
        }

        JavaAnnotationBuilder withType(JavaClassDescriptor type) {
            this.type = type;
            return this;
        }

        String getFullyQualifiedClassName() {
            return this.type.getFullyQualifiedClassName();
        }

        JavaAnnotationBuilder addProperty(String key, ValueBuilder valueBuilder) {
            this.values.put(key, valueBuilder);
            return this;
        }

        public JavaClass getType() {
            return this.importedClasses.getOrResolve(this.type.getFullyQualifiedClassName());
        }

        public <T extends HasDescription> Map<String, Object> getValues(T owner) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry<String, ValueBuilder> entry : this.values.entrySet()) {
                entry.getValue().build(owner, this.importedClasses).ifPresent(value -> result.put((String)entry.getKey(), value));
            }
            return result.build();
        }

        public <T extends HasDescription> JavaAnnotation<T> build(T owner, ImportedClasses importedClasses) {
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createJavaAnnotation(owner, this);
        }

        static abstract class ValueBuilder {
            ValueBuilder() {
            }

            abstract <T extends HasDescription> Optional<Object> build(T var1, ImportedClasses var2);

            static ValueBuilder fromPrimitiveProperty(final Object value) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses unused) {
                        return Optional.of(value);
                    }
                };
            }

            public static ValueBuilder fromEnumProperty(final JavaClassDescriptor enumType, final String value) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses importedClasses) {
                        return Optional.of(new JavaEnumConstantBuilder().withDeclaringClass(importedClasses.getOrResolve(enumType.getFullyQualifiedClassName())).withName(value).build());
                    }
                };
            }

            static ValueBuilder fromClassProperty(final JavaClassDescriptor value) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses importedClasses) {
                        return Optional.of(importedClasses.getOrResolve(value.getFullyQualifiedClassName()));
                    }
                };
            }

            static ValueBuilder fromAnnotationProperty(final JavaAnnotationBuilder builder) {
                return new ValueBuilder(){

                    @Override
                    <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses importedClasses) {
                        return Optional.of(builder.build(owner, importedClasses));
                    }
                };
            }
        }
    }

    static interface JavaTypeCreationProcess<OWNER> {
        public JavaType finish(OWNER var1, Iterable<JavaTypeVariable<?>> var2, ImportedClasses var3);

        public static abstract class JavaTypeFinisher {
            static final JavaTypeFinisher IDENTITY = new JavaTypeFinisher(){

                @Override
                JavaType finish(JavaType input, ImportedClasses classes) {
                    return input;
                }

                @Override
                String getFinishedName(String name) {
                    return name;
                }
            };
            static final JavaTypeFinisher ARRAY_CREATOR = new JavaTypeFinisher(){

                @Override
                public JavaType finish(JavaType componentType, ImportedClasses classes) {
                    JavaClassDescriptor erasureType = JavaClassDescriptor.From.javaClass(componentType.toErasure()).toArrayDescriptor();
                    if (componentType instanceof JavaClass) {
                        return classes.getOrResolve(erasureType.getFullyQualifiedClassName());
                    }
                    JavaClass erasure = classes.getOrResolve(erasureType.getFullyQualifiedClassName());
                    return DomainObjectCreationContext.createGenericArrayType(componentType, erasure);
                }

                @Override
                String getFinishedName(String name) {
                    return name + "[]";
                }
            };

            private JavaTypeFinisher() {
            }

            abstract JavaType finish(JavaType var1, ImportedClasses var2);

            abstract String getFinishedName(String var1);

            JavaTypeFinisher after(final JavaTypeFinisher other) {
                return new JavaTypeFinisher(){

                    @Override
                    JavaType finish(JavaType input, ImportedClasses classes) {
                        return this.finish(other.finish(input, classes), classes);
                    }

                    @Override
                    String getFinishedName(String name) {
                        return this.getFinishedName(other.getFinishedName(name));
                    }
                };
            }
        }
    }

    @Internal
    public static class CodeUnitAccessTargetBuilder<CODE_UNIT extends JavaCodeUnit, ACCESS_TARGET extends AccessTarget.CodeUnitAccessTarget>
    extends AccessTargetBuilder<CODE_UNIT, ACCESS_TARGET, CodeUnitAccessTargetBuilder<CODE_UNIT, ACCESS_TARGET>> {
        private List<JavaClass> parameters;
        private JavaClass returnType;

        private CodeUnitAccessTargetBuilder(Function<CodeUnitAccessTargetBuilder<CODE_UNIT, ACCESS_TARGET>, ACCESS_TARGET> createTarget) {
            super(createTarget);
        }

        CodeUnitAccessTargetBuilder<CODE_UNIT, ACCESS_TARGET> withParameters(List<JavaClass> parameters) {
            this.parameters = parameters;
            return (CodeUnitAccessTargetBuilder)this.self();
        }

        CodeUnitAccessTargetBuilder<CODE_UNIT, ACCESS_TARGET> withReturnType(JavaClass returnType) {
            this.returnType = returnType;
            return (CodeUnitAccessTargetBuilder)this.self();
        }

        public List<JavaClass> getParameters() {
            return this.parameters;
        }

        public JavaClass getReturnType() {
            return this.returnType;
        }

        @Override
        public String getFullName() {
            return Formatters.formatMethod(this.getOwner().getName(), this.getName(), HasName.Utils.namesOf(this.parameters));
        }
    }

    @Internal
    public static abstract class AccessTargetBuilder<MEMBER extends JavaMember, TARGET extends AccessTarget, SELF extends AccessTargetBuilder<MEMBER, TARGET, SELF>> {
        private final Function<SELF, TARGET> createTarget;
        private JavaClass owner;
        private String name;
        Supplier<Optional<MEMBER>> member;

        AccessTargetBuilder(Function<SELF, TARGET> createTarget) {
            this.createTarget = createTarget;
        }

        SELF withOwner(JavaClass owner) {
            this.owner = owner;
            return this.self();
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        SELF withMember(Supplier<Optional<MEMBER>> member) {
            this.member = member;
            return this.self();
        }

        TARGET build() {
            return (TARGET)((AccessTarget)this.createTarget.apply(this.self()));
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Optional<MEMBER>> getMember() {
            return this.member;
        }

        SELF self() {
            return (SELF)this;
        }

        public abstract String getFullName();
    }

    private static class ImportedParameterizedType
    implements JavaParameterizedType {
        private final JavaType type;
        private final List<JavaType> typeArguments;

        ImportedParameterizedType(JavaType type, List<JavaType> typeArguments) {
            Preconditions.checkArgument(typeArguments.size() > 0, "Parameterized type cannot be created without type arguments. This is likely a bug.");
            this.type = type;
            this.typeArguments = typeArguments;
        }

        @Override
        public String getName() {
            return this.type.getName() + this.formatTypeArguments();
        }

        @Override
        public JavaClass toErasure() {
            return this.type.toErasure();
        }

        @Override
        public List<JavaType> getActualTypeArguments() {
            return this.typeArguments;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.getName() + '}';
        }

        private String formatTypeArguments() {
            return this.typeArguments.stream().map(typeArgument -> Formatters.ensureCanonicalArrayTypeName(typeArgument.getName())).collect(Collectors.joining(", ", "<", ">"));
        }
    }

    @Internal
    public static final class FieldAccessTargetBuilder
    extends AccessTargetBuilder<JavaField, AccessTarget.FieldAccessTarget, FieldAccessTargetBuilder> {
        private JavaClass type;

        FieldAccessTargetBuilder() {
            super(DomainObjectCreationContext::createFieldAccessTarget);
        }

        FieldAccessTargetBuilder withType(JavaClass type) {
            this.type = type;
            return this;
        }

        public JavaClass getType() {
            return this.type;
        }

        @Override
        public String getFullName() {
            return this.getOwner().getName() + "." + this.getName();
        }
    }

    @Internal
    public static class JavaConstructorReferenceBuilder
    extends JavaAccessBuilder<AccessTarget.ConstructorReferenceTarget, JavaConstructorReferenceBuilder> {
        JavaConstructorReferenceBuilder() {
        }

        JavaConstructorReference build() {
            return DomainObjectCreationContext.createJavaConstructorReference(this);
        }
    }

    @Internal
    public static class JavaConstructorCallBuilder
    extends JavaAccessBuilder<AccessTarget.ConstructorCallTarget, JavaConstructorCallBuilder> {
        JavaConstructorCallBuilder() {
        }

        JavaConstructorCall build() {
            return DomainObjectCreationContext.createJavaConstructorCall(this);
        }
    }

    @Internal
    public static final class JavaMethodReferenceBuilder
    extends JavaAccessBuilder<AccessTarget.MethodReferenceTarget, JavaMethodReferenceBuilder> {
        JavaMethodReferenceBuilder() {
        }

        JavaMethodReference build() {
            return DomainObjectCreationContext.createJavaMethodReference(this);
        }
    }

    @Internal
    public static final class JavaMethodCallBuilder
    extends JavaAccessBuilder<AccessTarget.MethodCallTarget, JavaMethodCallBuilder> {
        JavaMethodCallBuilder() {
        }

        JavaMethodCall build() {
            return DomainObjectCreationContext.createJavaMethodCall(this);
        }
    }

    @Internal
    public static class JavaFieldAccessBuilder
    extends JavaAccessBuilder<AccessTarget.FieldAccessTarget, JavaFieldAccessBuilder> {
        private JavaFieldAccess.AccessType accessType;

        JavaFieldAccessBuilder() {
        }

        JavaFieldAccessBuilder withAccessType(JavaFieldAccess.AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public JavaFieldAccess.AccessType getAccessType() {
            return this.accessType;
        }

        JavaFieldAccess build() {
            return DomainObjectCreationContext.createJavaFieldAccess(this);
        }
    }

    @Internal
    public static abstract class JavaAccessBuilder<TARGET extends AccessTarget, SELF extends JavaAccessBuilder<TARGET, SELF>> {
        private JavaCodeUnit origin;
        private TARGET target;
        private int lineNumber;
        private boolean declaredInLambda;

        private JavaAccessBuilder() {
        }

        SELF withOrigin(JavaCodeUnit origin) {
            this.origin = origin;
            return this.self();
        }

        SELF withTarget(TARGET target) {
            this.target = target;
            return this.self();
        }

        SELF withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this.self();
        }

        SELF withDeclaredInLambda(boolean declaredInLambda) {
            this.declaredInLambda = declaredInLambda;
            return this.self();
        }

        public JavaCodeUnit getOrigin() {
            return this.origin;
        }

        public TARGET getTarget() {
            return this.target;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        private SELF self() {
            return (SELF)this;
        }

        public boolean isDeclaredInLambda() {
            return this.declaredInLambda;
        }
    }

    @Internal
    public static class TryCatchBlockBuilder {
        private Set<JavaClass> caughtThrowables;
        private int lineNumber;
        private JavaCodeUnit owner;
        private final Set<JavaAccess<?>> accessesContainedInTryBlock = new HashSet();
        private Set<RawAccessRecord> rawAccessesContainedInTryBlock;
        private boolean declaredInLambda;

        TryCatchBlockBuilder() {
        }

        TryCatchBlockBuilder withCaughtThrowables(Set<JavaClass> caughtThrowables) {
            this.caughtThrowables = caughtThrowables;
            return this;
        }

        TryCatchBlockBuilder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        TryCatchBlockBuilder withRawAccessesContainedInTryBlock(Set<RawAccessRecord> accessRecords) {
            this.rawAccessesContainedInTryBlock = accessRecords;
            return this;
        }

        void addIfContainedInTryBlock(RawAccessRecord rawRecord, JavaAccess<?> access) {
            if (this.rawAccessesContainedInTryBlock.contains(rawRecord)) {
                this.accessesContainedInTryBlock.add(access);
            }
        }

        TryCatchBlockBuilder withDeclaredInLambda(boolean declaredInLambda) {
            this.declaredInLambda = declaredInLambda;
            return this;
        }

        public TryCatchBlock build(JavaCodeUnit owner) {
            this.owner = owner;
            return DomainObjectCreationContext.createTryCatchBlock(this);
        }

        public JavaCodeUnit getOwner() {
            return this.owner;
        }

        public Set<JavaAccess<?>> getAccessesContainedInTryBlock() {
            return this.accessesContainedInTryBlock;
        }

        public Set<JavaClass> getCaughtThrowables() {
            return this.caughtThrowables;
        }

        public SourceCodeLocation getSourceCodeLocation() {
            return SourceCodeLocation.of(this.owner.getOwner(), this.lineNumber);
        }

        public boolean isDeclaredInLambda() {
            return this.declaredInLambda;
        }
    }

    @Internal
    static interface BuilderWithBuildParameter<PARAMETER, VALUE> {
        public VALUE build(PARAMETER var1, ImportedClasses var2);

        @Internal
        public static class BuildFinisher {
            static <PARAMETER, VALUE> Set<VALUE> build(Set<? extends BuilderWithBuildParameter<PARAMETER, ? extends VALUE>> builders, PARAMETER parameter, ImportedClasses importedClasses) {
                return BuildFinisher.build(builders.stream(), parameter, importedClasses);
            }

            static <PARAMETER, VALUE> Set<VALUE> build(Stream<? extends BuilderWithBuildParameter<PARAMETER, ? extends VALUE>> builders, PARAMETER parameter, ImportedClasses importedClasses) {
                Preconditions.checkNotNull(builders);
                Preconditions.checkNotNull(parameter);
                return builders.map(builder -> builder.build(parameter, importedClasses)).collect(ImmutableSet.toImmutableSet());
            }
        }
    }

    static class JavaParameterizedTypeBuilder<OWNER extends HasDescription>
    implements JavaTypeBuilder<OWNER> {
        private final JavaClassDescriptor type;
        private final List<JavaTypeCreationProcess<OWNER>> typeArgumentCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();

        JavaParameterizedTypeBuilder(JavaClassDescriptor type) {
            this.type = type;
        }

        void addTypeArgument(JavaTypeCreationProcess<OWNER> typeCreationProcess) {
            this.typeArgumentCreationProcesses.add(typeCreationProcess);
        }

        @Override
        public JavaType build(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses classes) {
            List typeArguments = DomainBuilders.buildJavaTypes(this.typeArgumentCreationProcesses, owner, allTypeParametersInContext, classes);
            return typeArguments.isEmpty() ? classes.getOrResolve(this.type.getFullyQualifiedClassName()) : new ImportedParameterizedType(classes.getOrResolve(this.type.getFullyQualifiedClassName()), typeArguments);
        }

        String getTypeName() {
            return this.type.getFullyQualifiedClassName();
        }

        JavaParameterizedTypeBuilder<OWNER> forInnerClass(String simpleInnerClassName) {
            return new JavaParameterizedTypeBuilder<OWNER>(JavaClassDescriptorImporter.createFromAsmObjectTypeName(this.type.getFullyQualifiedClassName() + '$' + simpleInnerClassName));
        }
    }

    @Internal
    public static final class JavaWildcardTypeBuilder<OWNER extends HasDescription>
    implements JavaTypeBuilder<OWNER> {
        private final List<JavaTypeCreationProcess<OWNER>> lowerBoundCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private final List<JavaTypeCreationProcess<OWNER>> upperBoundCreationProcesses = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private OWNER owner;
        private Iterable<JavaTypeVariable<?>> allTypeParametersInContext;
        private ImportedClasses importedClasses;

        JavaWildcardTypeBuilder() {
        }

        public JavaWildcardTypeBuilder<OWNER> addLowerBound(JavaTypeCreationProcess<OWNER> boundCreationProcess) {
            this.lowerBoundCreationProcesses.add(boundCreationProcess);
            return this;
        }

        public JavaWildcardTypeBuilder<OWNER> addUpperBound(JavaTypeCreationProcess<OWNER> boundCreationProcess) {
            this.upperBoundCreationProcesses.add(boundCreationProcess);
            return this;
        }

        @Override
        public JavaWildcardType build(OWNER owner, Iterable<JavaTypeVariable<?>> allTypeParametersInContext, ImportedClasses importedClasses) {
            this.owner = owner;
            this.allTypeParametersInContext = allTypeParametersInContext;
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createWildcardType(this);
        }

        public List<JavaType> getUpperBounds() {
            return DomainBuilders.buildJavaTypes(this.upperBoundCreationProcesses, this.owner, this.allTypeParametersInContext, this.importedClasses);
        }

        public List<JavaType> getLowerBounds() {
            return DomainBuilders.buildJavaTypes(this.lowerBoundCreationProcesses, this.owner, this.allTypeParametersInContext, this.importedClasses);
        }

        public JavaClass getUnboundErasureType(List<JavaType> upperBounds) {
            return DomainBuilders.getUnboundErasureType(upperBounds, this.importedClasses);
        }
    }

    static interface JavaTypeBuilder<OWNER extends HasDescription> {
        public JavaType build(OWNER var1, Iterable<JavaTypeVariable<?>> var2, ImportedClasses var3);
    }

    static class JavaCodeUnitTypeParametersBuilder
    extends AbstractTypeParametersBuilder<JavaCodeUnit> {
        JavaCodeUnitTypeParametersBuilder(List<JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders) {
            super(typeParameterBuilders);
        }

        @Override
        Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(JavaCodeUnit codeUnit) {
            return DomainBuilders.allTypeParametersInEnclosingContextOf(codeUnit);
        }
    }

    static class JavaClassTypeParametersBuilder
    extends AbstractTypeParametersBuilder<JavaClass> {
        JavaClassTypeParametersBuilder(List<JavaTypeParameterBuilder<JavaClass>> typeParameterBuilders) {
            super(typeParameterBuilders);
        }

        @Override
        Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(JavaClass javaClass) {
            return DomainBuilders.allTypeParametersInEnclosingContextOf(javaClass);
        }
    }

    private static abstract class AbstractTypeParametersBuilder<OWNER extends HasDescription> {
        private final List<JavaTypeParameterBuilder<OWNER>> typeParameterBuilders;

        AbstractTypeParametersBuilder(List<JavaTypeParameterBuilder<OWNER>> typeParameterBuilders) {
            this.typeParameterBuilders = typeParameterBuilders;
        }

        final List<JavaTypeVariable<OWNER>> build(OWNER owner, ImportedClasses ImportedClasses2) {
            if (this.typeParameterBuilders.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashMap<JavaTypeVariable<OWNER>, JavaTypeParameterBuilder<OWNER>> typeArgumentsToBuilders = new LinkedHashMap<JavaTypeVariable<OWNER>, JavaTypeParameterBuilder<OWNER>>();
            for (JavaTypeParameterBuilder<OWNER> builder : this.typeParameterBuilders) {
                typeArgumentsToBuilders.put(builder.build(owner, ImportedClasses2), builder);
            }
            Sets.SetView<JavaTypeVariable<?>> allGenericParametersInContext = Sets.union(this.typeParametersFromEnclosingContextOf(owner), typeArgumentsToBuilders.keySet());
            for (Map.Entry typeParameterToBuilder : typeArgumentsToBuilders.entrySet()) {
                List<JavaType> upperBounds = ((JavaTypeParameterBuilder)typeParameterToBuilder.getValue()).getUpperBounds(allGenericParametersInContext);
                DomainObjectCreationContext.completeTypeVariable((JavaTypeVariable)typeParameterToBuilder.getKey(), upperBounds);
            }
            return ImmutableList.copyOf(typeArgumentsToBuilders.keySet());
        }

        abstract Set<JavaTypeVariable<?>> typeParametersFromEnclosingContextOf(OWNER var1);
    }

    @Internal
    public static final class JavaTypeParameterBuilder<OWNER extends HasDescription> {
        private final String name;
        private final List<JavaTypeCreationProcess<OWNER>> upperBounds = new ArrayList<JavaTypeCreationProcess<OWNER>>();
        private OWNER owner;
        private ImportedClasses importedClasses;

        JavaTypeParameterBuilder(String name) {
            this.name = Preconditions.checkNotNull(name);
        }

        void addBound(JavaTypeCreationProcess<OWNER> bound) {
            this.upperBounds.add(bound);
        }

        public JavaTypeVariable<OWNER> build(OWNER owner, ImportedClasses importedClasses) {
            this.owner = owner;
            this.importedClasses = importedClasses;
            return DomainObjectCreationContext.createTypeVariable(this.name, owner, this.importedClasses.getOrResolve(Object.class.getName()));
        }

        String getName() {
            return this.name;
        }

        public List<JavaType> getUpperBounds(Iterable<? extends JavaTypeVariable<?>> allGenericParametersInContext) {
            return DomainBuilders.buildJavaTypes(this.upperBounds, this.owner, allGenericParametersInContext, this.importedClasses);
        }
    }

    @Internal
    public static final class JavaStaticInitializerBuilder
    extends JavaCodeUnitBuilder<JavaStaticInitializer, JavaStaticInitializerBuilder> {
        JavaStaticInitializerBuilder() {
            this.withReturnType(Optional.empty(), JavaClassDescriptor.From.name(Void.TYPE.getName()));
            this.withParameterTypes(Collections.emptyList(), Collections.emptyList());
            this.withName("<clinit>");
            this.withDescriptor("()V");
            this.withModifiers(Collections.emptySet());
            this.withThrowsClause(Collections.emptyList());
        }

        @Override
        JavaStaticInitializer construct(JavaStaticInitializerBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaStaticInitializer(builder);
        }
    }

    @Internal
    public static final class JavaClassBuilder {
        private final boolean stub;
        private Optional<SourceDescriptor> sourceDescriptor = Optional.empty();
        private Optional<String> sourceFileName = Optional.empty();
        private JavaClassDescriptor descriptor;
        private boolean isInterface;
        private boolean isEnum;
        private boolean isAnnotation;
        private boolean isRecord;
        private boolean isAnonymousClass;
        private boolean isMemberClass;
        private Set<JavaModifier> modifiers = new HashSet<JavaModifier>();

        JavaClassBuilder() {
            this(false);
        }

        private JavaClassBuilder(boolean stub) {
            this.stub = stub;
        }

        JavaClassBuilder withSourceDescriptor(SourceDescriptor sourceDescriptor) {
            this.sourceDescriptor = Optional.of(sourceDescriptor);
            return this;
        }

        JavaClassBuilder withSourceFileName(String sourceFileName) {
            this.sourceFileName = Optional.of(sourceFileName);
            return this;
        }

        JavaClassBuilder withDescriptor(JavaClassDescriptor descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        JavaClassBuilder withInterface(boolean isInterface) {
            this.isInterface = isInterface;
            return this;
        }

        JavaClassBuilder withAnonymousClass(boolean isAnonymousClass) {
            this.isAnonymousClass = isAnonymousClass;
            return this;
        }

        JavaClassBuilder withMemberClass(boolean isMemberClass) {
            this.isMemberClass = isMemberClass;
            return this;
        }

        JavaClassBuilder withEnum(boolean isEnum) {
            this.isEnum = isEnum;
            return this;
        }

        public JavaClassBuilder withAnnotation(boolean isAnnotation) {
            this.isAnnotation = isAnnotation;
            return this;
        }

        JavaClassBuilder withRecord(boolean isRecord) {
            this.isRecord = isRecord;
            return this;
        }

        JavaClassBuilder withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        JavaClassBuilder withSimpleName(String simpleName) {
            this.descriptor = this.descriptor.withSimpleClassName(simpleName);
            return this;
        }

        JavaClass build() {
            return DomainObjectCreationContext.createJavaClass(this);
        }

        public Optional<Source> getSource() {
            return this.sourceDescriptor.map(value -> DomainObjectCreationContext.createSource(value.getUri(), this.sourceFileName, value.isMd5InClassSourcesEnabled()));
        }

        public JavaClassDescriptor getDescriptor() {
            return this.descriptor;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isEnum() {
            return this.isEnum;
        }

        public boolean isAnnotation() {
            return this.isAnnotation;
        }

        public boolean isRecord() {
            return this.isRecord;
        }

        public boolean isAnonymousClass() {
            return this.isAnonymousClass;
        }

        public boolean isMemberClass() {
            return this.isMemberClass;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }

        public boolean isStub() {
            return this.stub;
        }

        static JavaClassBuilder forStub() {
            return new JavaClassBuilder(true);
        }
    }

    @Internal
    public static final class JavaConstructorBuilder
    extends JavaCodeUnitBuilder<JavaConstructor, JavaConstructorBuilder> {
        JavaConstructorBuilder() {
        }

        @Override
        JavaConstructor construct(JavaConstructorBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaConstructor(builder);
        }
    }

    @Internal
    public static final class JavaMethodBuilder
    extends JavaCodeUnitBuilder<JavaMethod, JavaMethodBuilder> {
        private static final Function<JavaMethod, Optional<Object>> NO_ANNOTATION_DEFAULT_VALUE = input -> Optional.empty();
        private Function<JavaMethod, Optional<Object>> createAnnotationDefaultValue = NO_ANNOTATION_DEFAULT_VALUE;

        JavaMethodBuilder() {
        }

        JavaMethodBuilder withAnnotationDefaultValue(Function<JavaMethod, Optional<Object>> createAnnotationDefaultValue) {
            this.createAnnotationDefaultValue = createAnnotationDefaultValue;
            return this;
        }

        @Override
        JavaMethod construct(JavaMethodBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaMethod(builder, this.createAnnotationDefaultValue);
        }
    }

    @Internal
    public static abstract class JavaCodeUnitBuilder<OUTPUT, SELF extends JavaCodeUnitBuilder<OUTPUT, SELF>>
    extends JavaMemberBuilder<OUTPUT, SELF> {
        private Optional<JavaTypeCreationProcess<JavaCodeUnit>> genericReturnType;
        private JavaClassDescriptor rawReturnType;
        private List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypes;
        private List<JavaClassDescriptor> rawParameterTypes;
        private SetMultimap<Integer, JavaAnnotationBuilder> parameterAnnotationsByIndex;
        private JavaCodeUnitTypeParametersBuilder typeParametersBuilder;
        private List<JavaClassDescriptor> throwsDeclarations;

        private JavaCodeUnitBuilder() {
        }

        SELF withReturnType(Optional<JavaTypeCreationProcess<JavaCodeUnit>> genericReturnType, JavaClassDescriptor rawReturnType) {
            this.genericReturnType = genericReturnType;
            this.rawReturnType = rawReturnType;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withParameterTypes(List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypes, List<JavaClassDescriptor> rawParameterTypes) {
            this.genericParameterTypes = genericParameterTypes;
            this.rawParameterTypes = rawParameterTypes;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withParameterAnnotations(SetMultimap<Integer, JavaAnnotationBuilder> parameterAnnotationsByIndex) {
            this.parameterAnnotationsByIndex = parameterAnnotationsByIndex;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withTypeParameters(List<JavaTypeParameterBuilder<JavaCodeUnit>> typeParameterBuilders) {
            this.typeParametersBuilder = new JavaCodeUnitTypeParametersBuilder(typeParameterBuilders);
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        SELF withThrowsClause(List<JavaClassDescriptor> throwsDeclarations) {
            this.throwsDeclarations = throwsDeclarations;
            return (SELF)((JavaCodeUnitBuilder)this.self());
        }

        String getReturnTypeName() {
            return this.rawReturnType.getFullyQualifiedClassName();
        }

        boolean hasNoParameters() {
            return this.rawParameterTypes.isEmpty();
        }

        public JavaClass getRawReturnType() {
            return this.get(this.rawReturnType.getFullyQualifiedClassName());
        }

        public JavaType getGenericReturnType(JavaCodeUnit codeUnit) {
            return this.genericReturnType.isPresent() ? this.genericReturnType.get().finish(codeUnit, this.allTypeParametersInContextOf(codeUnit), this.importedClasses) : this.getRawReturnType();
        }

        private Iterable<JavaTypeVariable<?>> allTypeParametersInContextOf(JavaCodeUnit codeUnit) {
            return FluentIterable.from(DomainBuilders.getTypeParametersOf(codeUnit)).append(DomainBuilders.allTypeParametersInEnclosingContextOf(codeUnit));
        }

        public List<JavaClass> getRawParameterTypes() {
            return this.asJavaClasses(this.rawParameterTypes);
        }

        public List<JavaType> getGenericParameterTypes(JavaCodeUnit codeUnit) {
            return this.build(this.genericParameterTypes, codeUnit);
        }

        private List<JavaType> build(List<JavaTypeCreationProcess<JavaCodeUnit>> genericParameterTypeBuilders, JavaCodeUnit codeUnit) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaTypeCreationProcess<JavaCodeUnit> parameterTypeBuilder : genericParameterTypeBuilders) {
                result.add(parameterTypeBuilder.finish(codeUnit, this.allTypeParametersInContextOf(codeUnit), this.importedClasses));
            }
            return result.build();
        }

        public List<JavaTypeVariable<JavaCodeUnit>> getTypeParameters(JavaCodeUnit owner) {
            return this.typeParametersBuilder.build(owner, this.importedClasses);
        }

        public <CODE_UNIT extends JavaCodeUnit> ThrowsClause<CODE_UNIT> getThrowsClause(CODE_UNIT codeUnit) {
            return DomainObjectCreationContext.createThrowsClause(codeUnit, this.asJavaClasses(this.throwsDeclarations));
        }

        private List<JavaClass> asJavaClasses(List<JavaClassDescriptor> descriptors) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (JavaClassDescriptor javaClassDescriptor : descriptors) {
                result.add(this.get(javaClassDescriptor.getFullyQualifiedClassName()));
            }
            return result.build();
        }

        public ParameterAnnotationsBuilder getParameterAnnotationsBuilder(int index) {
            return new ParameterAnnotationsBuilder(this.parameterAnnotationsByIndex.get((Object)index), this.importedClasses);
        }

        @Internal
        public static class ParameterAnnotationsBuilder {
            private final Iterable<JavaAnnotationBuilder> annotationBuilders;
            private final ImportedClasses importedClasses;

            private ParameterAnnotationsBuilder(Iterable<JavaAnnotationBuilder> annotationBuilders, ImportedClasses importedClasses) {
                this.annotationBuilders = annotationBuilders;
                this.importedClasses = importedClasses;
            }

            public Set<JavaAnnotation<JavaParameter>> build(JavaParameter owner) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (JavaAnnotationBuilder annotationBuilder : this.annotationBuilders) {
                    result.add(annotationBuilder.build(owner, this.importedClasses));
                }
                return result.build();
            }
        }
    }

    @Internal
    public static final class JavaFieldBuilder
    extends JavaMemberBuilder<JavaField, JavaFieldBuilder> {
        private Optional<JavaTypeCreationProcess<JavaField>> genericType;
        private JavaClassDescriptor rawType;

        JavaFieldBuilder() {
        }

        JavaFieldBuilder withType(Optional<JavaTypeCreationProcess<JavaField>> genericTypeBuilder, JavaClassDescriptor rawType) {
            this.genericType = Preconditions.checkNotNull(genericTypeBuilder);
            this.rawType = Preconditions.checkNotNull(rawType);
            return (JavaFieldBuilder)this.self();
        }

        public JavaType getType(JavaField field) {
            return this.genericType.isPresent() ? this.genericType.get().finish(field, JavaFieldBuilder.allTypeParametersInContextOf(field.getOwner()), this.importedClasses) : this.importedClasses.getOrResolve(this.rawType.getFullyQualifiedClassName());
        }

        private static Iterable<JavaTypeVariable<?>> allTypeParametersInContextOf(JavaClass javaClass) {
            return FluentIterable.from(DomainBuilders.getTypeParametersOf(javaClass)).append(DomainBuilders.allTypeParametersInEnclosingContextOf(javaClass));
        }

        @Override
        JavaField construct(JavaFieldBuilder builder, ImportedClasses importedClasses) {
            return DomainObjectCreationContext.createJavaField(builder);
        }
    }

    @Internal
    public static abstract class JavaMemberBuilder<OUTPUT, SELF extends JavaMemberBuilder<OUTPUT, SELF>>
    implements BuilderWithBuildParameter<JavaClass, OUTPUT> {
        private String name;
        private String descriptor;
        private Set<JavaModifier> modifiers;
        private JavaClass owner;
        ImportedClasses importedClasses;
        private int firstLineNumber;

        private JavaMemberBuilder() {
        }

        SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        SELF withDescriptor(String descriptor) {
            this.descriptor = descriptor;
            return this.self();
        }

        SELF withModifiers(Set<JavaModifier> modifiers) {
            this.modifiers = modifiers;
            return this.self();
        }

        void recordLineNumber(int lineNumber) {
            this.firstLineNumber = this.firstLineNumber == 0 ? lineNumber : Math.min(this.firstLineNumber, lineNumber);
        }

        SELF self() {
            return (SELF)this;
        }

        abstract OUTPUT construct(SELF var1, ImportedClasses var2);

        JavaClass get(String typeName) {
            return this.importedClasses.getOrResolve(typeName);
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public Set<JavaModifier> getModifiers() {
            return this.modifiers;
        }

        public JavaClass getOwner() {
            return this.owner;
        }

        public int getFirstLineNumber() {
            return this.firstLineNumber;
        }

        @Override
        public final OUTPUT build(JavaClass owner, ImportedClasses importedClasses) {
            this.owner = owner;
            this.importedClasses = importedClasses;
            return this.construct(this.self(), importedClasses);
        }
    }

    @Internal
    public static final class JavaEnumConstantBuilder {
        private JavaClass declaringClass;
        private String name;

        JavaEnumConstantBuilder() {
        }

        JavaEnumConstantBuilder withDeclaringClass(JavaClass declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        JavaEnumConstantBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public JavaClass getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        JavaEnumConstant build() {
            return DomainObjectCreationContext.createJavaEnumConstant(this);
        }
    }
}

