/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.JoinCondition;
import com.tngtech.archunit.lang.conditions.OrCondition;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;

class AndCondition<T>
extends JoinCondition<T> {
    AndCondition(ArchCondition<T> first, ArchCondition<T> second) {
        super("and", ImmutableList.of(first, second));
    }

    @Override
    public void check(T item, ConditionEvents events) {
        events.add(new AndConditionEvent<T>(item, this.evaluateConditions(item)));
    }

    static class AndConditionEvent<T>
    extends JoinCondition.JoinConditionEvent<T> {
        AndConditionEvent(T item, List<JoinCondition.ConditionWithEvents<T>> evaluatedConditions) {
            super(item, evaluatedConditions);
        }

        @Override
        public boolean isViolation() {
            return this.evaluatedConditions.stream().anyMatch(evaluation -> evaluation.getEvents().containViolation());
        }

        @Override
        public ConditionEvent invert() {
            return new OrCondition.OrConditionEvent<Object>(this.correspondingObject, this.invert(this.evaluatedConditions));
        }

        @Override
        public List<String> getDescriptionLines() {
            return this.getUniqueLinesOfViolations();
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            for (JoinCondition.ConditionWithEvents condition : this.evaluatedConditions) {
                condition.getEvents().getViolating().forEach(event -> event.handleWith(handler));
            }
        }
    }
}

