/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class DependencyRules {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_DEPEND_UPPER_PACKAGES = ArchRuleDefinition.noClasses().should(DependencyRules.dependOnUpperPackages()).because("that might prevent packages on that level from being split into separate artifacts in a clean way");

    private DependencyRules() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> dependOnUpperPackages() {
        return new DependOnUpperPackagesCondition();
    }

    private static class DependOnUpperPackagesCondition
    extends ArchCondition<JavaClass> {
        DependOnUpperPackagesCondition() {
            super("depend on upper packages", new Object[0]);
        }

        @Override
        public void check(JavaClass clazz, ConditionEvents events) {
            for (Dependency dependency : clazz.getDirectDependenciesFromSelf()) {
                boolean dependencyOnUpperPackage = this.isDependencyOnUpperPackage(dependency.getOriginClass(), dependency.getTargetClass());
                events.add(new SimpleConditionEvent(dependency, dependencyOnUpperPackage, dependency.getDescription()));
            }
        }

        private boolean isDependencyOnUpperPackage(JavaClass origin, JavaClass target) {
            String originPackageName = origin.getPackageName();
            String targetSubPackagePrefix = target.getPackageName() + ".";
            return originPackageName.startsWith(targetSubPackagePrefix);
        }
    }
}

