/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;

@FunctionalInterface
@API(status=API.Status.STABLE, since="5.7")
public interface TestInstancePreDestroyCallback
extends Extension {
    public void preDestroyTestInstance(ExtensionContext var1) throws Exception;

    @API(status=API.Status.STABLE, since="5.10")
    public static void preDestroyTestInstances(ExtensionContext context, Consumer<Object> callback) {
        ArrayList<Object> destroyedInstances = new ArrayList<Object>(context.getRequiredTestInstances().getAllInstances());
        Optional<ExtensionContext> current = context.getParent();
        while (current.isPresent()) {
            current.get().getTestInstances().map(TestInstances::getAllInstances).ifPresent(destroyedInstances::removeAll);
            current = current.get().getParent();
        }
        Collections.reverse(destroyedInstances);
        destroyedInstances.forEach(callback);
    }
}

