/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class ConcurrentCache<K, V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
    private final LinkedHashMap<K, V> cache;

    public ConcurrentCache(final IntSupplier maxSize) {
        this.cache = new LinkedHashMap<K, V>(maxSize.getAsInt() + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxSize.getAsInt();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(K key, Supplier<? extends V> supplier) {
        V value;
        this.readLock.lock();
        try {
            value = this.cache.get(key);
            if (null != value) {
                V v = value;
                return v;
            }
        }
        finally {
            this.readLock.unlock();
        }
        value = supplier.get();
        this.writeLock.lock();
        try {
            V oldValue = this.cache.putIfAbsent(key, value);
            V v = null != oldValue ? oldValue : value;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

